/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.Config;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.ClusterException;
import net.kuujo.vertigo.cluster.Group;
import net.kuujo.vertigo.cluster.Node;
import net.kuujo.vertigo.cluster.data.AsyncCounter;
import net.kuujo.vertigo.cluster.data.AsyncList;
import net.kuujo.vertigo.cluster.data.AsyncMap;
import net.kuujo.vertigo.cluster.data.AsyncMultiMap;
import net.kuujo.vertigo.cluster.data.AsyncQueue;
import net.kuujo.vertigo.cluster.data.AsyncSet;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncCounter;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncList;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncMap;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncMultiMap;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncQueue;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncSet;
import net.kuujo.vertigo.cluster.impl.DefaultGroup;
import net.kuujo.vertigo.cluster.impl.DefaultNode;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.ModuleConfig;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultActiveNetwork;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.util.Configs;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

public class DefaultCluster
implements Cluster {
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private final String address;
    private final Vertx vertx;
    private final Container container;
    private final Map<Handler<Node>, Handler<Message<String>>> joinHandlers = new HashMap<Handler<Node>, Handler<Message<String>>>();
    private final Map<Handler<Node>, Handler<Message<String>>> leaveHandlers = new HashMap<Handler<Node>, Handler<Message<String>>>();

    public DefaultCluster(String address, Vertx vertx, Container container) {
        this.address = address;
        this.vertx = vertx;
        this.container = container;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Cluster registerJoinHandler(Handler<Node> handler) {
        return this.registerJoinHandler(handler, null);
    }

    @Override
    public Cluster registerJoinHandler(final Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = new Handler<Message<String>>(){

            public void handle(Message<String> message) {
                handler.handle((Object)new DefaultNode((String)message.body(), DefaultCluster.this.vertx, DefaultCluster.this.container));
            }
        };
        this.joinHandlers.put(handler, messageHandler);
        this.vertx.eventBus().registerHandler(String.format("%s.join", this.address), (Handler)messageHandler, doneHandler);
        return this;
    }

    @Override
    public Cluster unregisterJoinHandler(Handler<Node> handler) {
        return this.unregisterJoinHandler(handler, null);
    }

    @Override
    public Cluster unregisterJoinHandler(Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = this.joinHandlers.remove(handler);
        if (messageHandler != null) {
            this.vertx.eventBus().unregisterHandler(String.format("%s.join", this.address), messageHandler, doneHandler);
        } else {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public Cluster registerLeaveHandler(Handler<Node> handler) {
        return this.registerLeaveHandler(handler, null);
    }

    @Override
    public Cluster registerLeaveHandler(final Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = new Handler<Message<String>>(){

            public void handle(Message<String> message) {
                handler.handle((Object)new DefaultNode((String)message.body(), DefaultCluster.this.vertx, DefaultCluster.this.container));
            }
        };
        this.leaveHandlers.put(handler, messageHandler);
        this.vertx.eventBus().registerHandler(String.format("%s.leave", this.address), (Handler)messageHandler, doneHandler);
        return this;
    }

    @Override
    public Cluster unregisterLeaveHandler(Handler<Node> handler) {
        return this.unregisterLeaveHandler(handler, null);
    }

    @Override
    public Cluster unregisterLeaveHandler(Handler<Node> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<String>> messageHandler = this.leaveHandlers.remove(handler);
        if (messageHandler != null) {
            this.vertx.eventBus().unregisterHandler(String.format("%s.leave", this.address), messageHandler, doneHandler);
        } else {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public Cluster ping(final Handler<AsyncResult<Cluster>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "ping");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("pong")) {
                    if (((JsonObject)((Message)result.result()).body()).getString("result").equals("cluster")) {
                        new DefaultFutureResult((Object)DefaultCluster.this).setHandler(resultHandler);
                    } else {
                        new DefaultFutureResult((Throwable)((Object)new ClusterException("Not a valid cluster address."))).setHandler(resultHandler);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Cluster getGroup(String group, final Handler<AsyncResult<Group>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "find").putString("type", "group").putString("group", group);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)new DefaultGroup(((JsonObject)((Message)result.result()).body()).getString("result"), DefaultCluster.this.vertx, DefaultCluster.this.container)).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster getGroups(final Handler<AsyncResult<Collection<Group>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "list").putString("type", "group");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    JsonArray jsonGroups = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    ArrayList<DefaultGroup> groups = new ArrayList<DefaultGroup>();
                    for (Object jsonGroup : jsonGroups) {
                        groups.add(new DefaultGroup((String)jsonGroup, DefaultCluster.this.vertx, DefaultCluster.this.container));
                    }
                    new DefaultFutureResult(groups).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster selectGroup(Object key, final Handler<AsyncResult<Group>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "select").putString("type", "group").putValue("key", key);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)new DefaultGroup(((JsonObject)((Message)result.result()).body()).getString("result"), DefaultCluster.this.vertx, DefaultCluster.this.container)).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster getNode(String node, final Handler<AsyncResult<Node>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "find").putString("type", "node").putString("node", node);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)new DefaultNode(((JsonObject)((Message)result.result()).body()).getString("result"), DefaultCluster.this.vertx, DefaultCluster.this.container)).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster getNodes(final Handler<AsyncResult<Collection<Node>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "list").putString("type", "node");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    JsonArray jsonNodes = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    ArrayList<DefaultNode> nodes = new ArrayList<DefaultNode>();
                    for (Object jsonNode : jsonNodes) {
                        nodes.add(new DefaultNode((String)jsonNode, DefaultCluster.this.vertx, DefaultCluster.this.container));
                    }
                    new DefaultFutureResult(nodes).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster selectNode(Object key, final Handler<AsyncResult<Node>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "select").putString("type", "node").putValue("key", key);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)new DefaultNode(((JsonObject)((Message)result.result()).body()).getString("result"), DefaultCluster.this.vertx, DefaultCluster.this.container)).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster installModule(String moduleName) {
        return this.installModule(moduleName, null);
    }

    @Override
    public Cluster installModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        this.getNodes(new Handler<AsyncResult<Collection<Node>>>(){

            public void handle(AsyncResult<Collection<Node>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    CountingCompletionHandler<Void> counter = new CountingCompletionHandler(((Collection)result.result()).size()).setHandler(doneHandler);
                    for (Node node : (Collection)result.result()) {
                        node.installModule(moduleName, counter);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Cluster uninstallModule(String moduleName) {
        return this.uninstallModule(moduleName, null);
    }

    @Override
    public Cluster uninstallModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        this.getNodes(new Handler<AsyncResult<Collection<Node>>>(){

            public void handle(AsyncResult<Collection<Node>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    CountingCompletionHandler<Void> counter = new CountingCompletionHandler(((Collection)result.result()).size()).setHandler(doneHandler);
                    for (Node node : (Collection)result.result()) {
                        node.uninstallModule(moduleName, counter);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployModule(String moduleName) {
        return this.deployModule(moduleName, null, 1, null);
    }

    @Override
    public Cluster deployModule(String moduleName, JsonObject config) {
        return this.deployModule(moduleName, config, 1, null);
    }

    @Override
    public Cluster deployModule(String moduleName, int instances) {
        return this.deployModule(moduleName, null, instances, null);
    }

    @Override
    public Cluster deployModule(String moduleName, JsonObject config, int instances) {
        return this.deployModule(moduleName, config, instances, null);
    }

    @Override
    public Cluster deployModule(String moduleName, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, null, 1, doneHandler);
    }

    @Override
    public Cluster deployModule(String moduleName, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, config, 1, doneHandler);
    }

    @Override
    public Cluster deployModule(String moduleName, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModule(moduleName, null, instances, doneHandler);
    }

    @Override
    public Cluster deployModule(String moduleName, JsonObject config, int instances, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "module").putString("module", moduleName).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployVerticle(String main) {
        return this.deployVerticle(main, null, 1, null);
    }

    @Override
    public Cluster deployVerticle(String main, JsonObject config) {
        return this.deployVerticle(main, config, 1, null);
    }

    @Override
    public Cluster deployVerticle(String main, int instances) {
        return this.deployVerticle(main, null, instances, null);
    }

    @Override
    public Cluster deployVerticle(String main, JsonObject config, int instances) {
        return this.deployVerticle(main, config, instances, null);
    }

    @Override
    public Cluster deployVerticle(String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, null, 1, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, config, 1, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticle(main, null, instances, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String main, JsonObject config, int instances, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "verticle").putString("main", main).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployWorkerVerticle(String main) {
        return this.deployWorkerVerticle(main, null, 1, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, JsonObject config) {
        return this.deployWorkerVerticle(main, config, 1, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, int instances) {
        return this.deployWorkerVerticle(main, null, instances, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded) {
        return this.deployWorkerVerticle(main, config, instances, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, null, 1, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, config, 1, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticle(main, null, instances, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String main, JsonObject config, int instances, boolean multiThreaded, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "verticle").putString("main", main).putObject("config", config != null ? config : new JsonObject()).putNumber("instances", (Number)instances).putBoolean("worker", Boolean.valueOf(true)).putBoolean("multi-threaded", Boolean.valueOf(multiThreaded));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster undeployModule(String deploymentID) {
        return this.undeployModule(deploymentID, null);
    }

    @Override
    public Cluster undeployModule(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "module").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster undeployVerticle(String deploymentID) {
        return this.undeployVerticle(deploymentID, null);
    }

    @Override
    public Cluster undeployVerticle(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "verticle").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster getNetworks(final Handler<AsyncResult<Collection<ActiveNetwork>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "list").putString("type", "network");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    final ArrayList networks = new ArrayList();
                    JsonArray jsonNetworks = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    final CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(jsonNetworks.size());
                    counter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                            } else {
                                new DefaultFutureResult((Object)networks).setHandler(resultHandler);
                            }
                        }
                    });
                    for (Object jsonNetwork : jsonNetworks) {
                        DefaultCluster.this.createActiveNetwork(DefaultNetworkContext.fromJson((JsonObject)jsonNetwork), (Handler<AsyncResult<ActiveNetwork>>)((Handler)new Handler<AsyncResult<ActiveNetwork>>(){

                            public void handle(AsyncResult<ActiveNetwork> result) {
                                if (result.failed()) {
                                    counter.fail(result.cause());
                                } else {
                                    networks.add(result.result());
                                    counter.succeed();
                                }
                            }
                        }));
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Cluster getNetwork(String name, final Handler<AsyncResult<ActiveNetwork>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "find").putString("type", "network").putString("network", name);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    DefaultCluster.this.createActiveNetwork(DefaultNetworkContext.fromJson(((JsonObject)((Message)result.result()).body()).getObject("result")), (Handler<AsyncResult<ActiveNetwork>>)resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployNetwork(String name) {
        return this.deployNetwork(name, null);
    }

    @Override
    public Cluster deployNetwork(String name, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.deployNetwork(new DefaultNetworkConfig(name), doneHandler);
    }

    @Override
    public Cluster deployNetwork(JsonObject network) {
        return this.deployNetwork(network, null);
    }

    @Override
    public Cluster deployNetwork(JsonObject network, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.deployNetwork(Configs.createNetwork(network), doneHandler);
    }

    @Override
    public Cluster deployNetwork(NetworkConfig network) {
        return this.deployNetwork(network, null);
    }

    @Override
    public Cluster deployNetwork(final NetworkConfig network, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.selectNode(network.getName(), new Handler<AsyncResult<Node>>(){

            public void handle(AsyncResult<Node> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    Node node = (Node)result.result();
                    ArrayList<ModuleConfig> modules = new ArrayList<ModuleConfig>();
                    for (ComponentConfig<?> component : network.getComponents()) {
                        if (!component.getType().equals((Object)ComponentConfig.Type.MODULE)) continue;
                        modules.add((ModuleConfig)component);
                    }
                    CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(modules.size());
                    counter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "network").putObject("network", SerializerFactory.getSerializer(Config.class).serializeToObject(network));
                                DefaultCluster.this.vertx.eventBus().sendWithTimeout(DefaultCluster.this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                                    public void handle(AsyncResult<Message<JsonObject>> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                                        } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                                            new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                                        } else {
                                            DefaultCluster.this.createActiveNetwork(DefaultNetworkContext.fromJson(((JsonObject)((Message)result.result()).body()).getObject("context")), (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    for (ModuleConfig module : modules) {
                        node.installModule(module.getModule(), counter);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public Cluster undeployNetwork(String name) {
        return this.undeployNetwork(name, null);
    }

    @Override
    public Cluster undeployNetwork(String name, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "network").putString("network", name);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster undeployNetwork(JsonObject network) {
        return this.undeployNetwork(network, null);
    }

    @Override
    public Cluster undeployNetwork(JsonObject network, Handler<AsyncResult<Void>> doneHandler) {
        return this.undeployNetwork(Configs.createNetwork(network), doneHandler);
    }

    @Override
    public Cluster undeployNetwork(NetworkConfig network) {
        return this.undeployNetwork(network, null);
    }

    @Override
    public Cluster undeployNetwork(NetworkConfig network, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "network").putObject("network", SerializerFactory.getSerializer(Config.class).serializeToObject(network));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    private void createActiveNetwork(NetworkContext context, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        final DefaultActiveNetwork active = new DefaultActiveNetwork(context.config(), this);
        this.vertx.eventBus().registerHandler(String.format("%s.%s.change", context.name(), context.name()), (Handler)new Handler<Message<JsonObject>>(){

            public void handle(Message<JsonObject> message) {
                String event = ((JsonObject)message.body()).getString("type");
                if (event.equals("change") && ((JsonObject)message.body()).getString("value") != null) {
                    active.update(DefaultNetworkContext.fromJson(new JsonObject(((JsonObject)message.body()).getString("value"))));
                }
            }
        }, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterException(result.cause()))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)active).setHandler(doneHandler);
                }
            }
        });
    }

    @Override
    public <K, V> AsyncMap<K, V> getMap(String name) {
        return new DefaultAsyncMap(this.address, name, this.vertx);
    }

    @Override
    public <K, V> AsyncMultiMap<K, V> getMultiMap(String name) {
        return new DefaultAsyncMultiMap(this.address, name, this.vertx);
    }

    @Override
    public <T> AsyncSet<T> getSet(String name) {
        return new DefaultAsyncSet(this.address, name, this.vertx);
    }

    @Override
    public <T> AsyncList<T> getList(String name) {
        return new DefaultAsyncList(this.address, name, this.vertx);
    }

    @Override
    public <T> AsyncQueue<T> getQueue(String name) {
        return new DefaultAsyncQueue(this.address, name, this.vertx);
    }

    @Override
    public AsyncCounter getCounter(String name) {
        return new DefaultAsyncCounter(this.address, name, this.vertx);
    }

    public String toString() {
        return String.format("cluster:%s", this.address);
    }

    public boolean equals(Object object) {
        return object instanceof Cluster && ((Cluster)object).address().equals(this.address);
    }
}

