/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.data;

import net.kuujo.vertigo.util.serialization.JsonSerializable;

public class MapEvent<K, V>
implements JsonSerializable {
    private Type type;
    private K key;
    private V value;

    public MapEvent(Type type, K key, V value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public Type type() {
        return this.type;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public static enum Type {
        CREATE("create"),
        UPDATE("update"),
        CHANGE("change"),
        DELETE("delete");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Type parse(String name) {
            switch (name) {
                case "create": {
                    return CREATE;
                }
                case "update": {
                    return UPDATE;
                }
                case "change": {
                    return CHANGE;
                }
                case "delete": {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException(name + " is not a valid event type.");
        }
    }
}

