/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.kuujo.vertigo.io.Input;
import net.kuujo.vertigo.io.group.InputGroup;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;

public class FileReceiver {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private final Input<?> input;
    private Handler<String> fileHandler;
    private Handler<Throwable> exceptionHandler;
    private File tempDir;
    private final Handler<InputGroup> groupHandler = new Handler<InputGroup>(){

        public void handle(InputGroup group) {
            FileReceiver.this.handleFile(group);
        }
    };

    public FileReceiver(Input<?> input) {
        this.input = input;
        this.tempDir = new File(TEMP_DIR);
    }

    public FileReceiver fileHandler(Handler<String> handler) {
        this.fileHandler = handler;
        this.init();
        return this;
    }

    public FileReceiver exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private void init() {
        if (this.fileHandler != null) {
            this.input.groupHandler("file", this.groupHandler);
        } else {
            this.input.groupHandler("file", null);
        }
    }

    private void handleFile(final InputGroup group) {
        group.startHandler((Handler)new Handler<String>(){

            public void handle(String fileName) {
                final File file = new File(FileReceiver.this.tempDir, String.format("temp-%s-%s", UUID.randomUUID().toString(), fileName));
                FileReceiver.this.input.vertx().fileSystem().open(file.getAbsolutePath(), (Handler)new Handler<AsyncResult<AsyncFile>>(){

                    public void handle(AsyncResult<AsyncFile> result) {
                        if (result.succeeded()) {
                            FileReceiver.this.handleFile(file.getAbsolutePath(), (AsyncFile)result.result(), group);
                        } else if (FileReceiver.this.exceptionHandler != null) {
                            FileReceiver.this.exceptionHandler.handle((Object)result.cause());
                        }
                    }
                });
            }
        });
    }

    private void handleFile(final String filePath, final AsyncFile file, final InputGroup group) {
        final AtomicLong position = new AtomicLong();
        final AtomicBoolean complete = new AtomicBoolean();
        final AtomicInteger handlerCount = new AtomicInteger();
        group.messageHandler((Handler)new Handler<Buffer>(){

            public synchronized void handle(Buffer buffer) {
                file.write(buffer, position.get(), (Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.failed()) {
                            file.close();
                            group.messageHandler(null);
                            group.endHandler(null);
                            try {
                                FileReceiver.this.input.vertx().fileSystem().deleteSync(filePath);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (FileReceiver.this.exceptionHandler != null) {
                                FileReceiver.this.exceptionHandler.handle((Object)result.cause());
                            }
                        }
                        handlerCount.decrementAndGet();
                        if (complete.get() && handlerCount.get() == 0) {
                            FileReceiver.this.closeFile(filePath, file);
                        }
                    }
                });
                handlerCount.incrementAndGet();
                position.addAndGet(buffer.length());
            }
        });
        group.endHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                complete.set(true);
                if (handlerCount.get() == 0) {
                    FileReceiver.this.closeFile(filePath, file);
                }
            }
        });
    }

    private void closeFile(final String filePath, AsyncFile file) {
        file.close((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    try {
                        FileReceiver.this.input.vertx().fileSystem().deleteSync(filePath);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (FileReceiver.this.exceptionHandler != null) {
                        FileReceiver.this.exceptionHandler.handle((Object)result.cause());
                    }
                } else if (FileReceiver.this.fileHandler != null) {
                    FileReceiver.this.fileHandler.handle((Object)filePath);
                }
            }
        });
    }
}

