/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.util;

import java.io.Externalizable;
import java.io.IOException;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferObjectInput;
import net.kuujo.catalyst.buffer.BufferObjectOutput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializationException;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class ExternalizableSerializer
implements TypeSerializer<Externalizable> {
    @Override
    public void write(Externalizable externalizable, BufferOutput buffer, Serializer serializer) {
        try {
            externalizable.writeExternal(new BufferObjectOutput(buffer, serializer));
        }
        catch (IOException e) {
            throw new SerializationException("failed to serialize externalizable type: " + externalizable.getClass(), e);
        }
    }

    @Override
    public Externalizable read(Class<Externalizable> type, BufferInput buffer, Serializer serializer) {
        try {
            Externalizable externalizable = type.newInstance();
            externalizable.readExternal(new BufferObjectInput(buffer, serializer));
            return externalizable;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SerializationException("failed to instantiate externalizable type: " + type, e);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializationException("failed to deserialize externalizable type: " + type, e);
        }
    }
}

