/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.util;

import java.util.Calendar;
import java.util.TimeZone;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class CalendarSerializer
implements TypeSerializer<Calendar> {
    @Override
    public void write(Calendar calendar, BufferOutput buffer, Serializer serializer) {
        buffer.writeUTF8(calendar.getTimeZone().getID());
        buffer.writeLong(calendar.getTimeInMillis());
    }

    @Override
    public Calendar read(Class<Calendar> type, BufferInput buffer, Serializer serializer) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(buffer.readUTF8()));
        calendar.setTimeInMillis(buffer.readLong());
        return calendar;
    }
}

