/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.util;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class BigDecimalSerializer
implements TypeSerializer<BigDecimal> {
    @Override
    public void write(BigDecimal object, BufferOutput buffer, Serializer serializer) {
        byte[] bytes = object.toPlainString().getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length).write(bytes);
    }

    @Override
    public BigDecimal read(Class<BigDecimal> type, BufferInput buffer, Serializer serializer) {
        byte[] bytes = new byte[buffer.readInt()];
        buffer.read(bytes);
        return new BigDecimal(new String(bytes, StandardCharsets.UTF_8));
    }
}

