/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class ShortArraySerializer
implements TypeSerializer<short[]> {
    @Override
    public void write(short[] shorts, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(shorts.length);
        for (short s : shorts) {
            buffer.writeShort(s);
        }
    }

    @Override
    public short[] read(Class<short[]> type, BufferInput buffer, Serializer serializer) {
        short[] shorts = new short[buffer.readUnsignedShort()];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = buffer.readShort();
        }
        return shorts;
    }
}

