/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class FloatArraySerializer
implements TypeSerializer<float[]> {
    @Override
    public void write(float[] floats, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(floats.length);
        for (float f : floats) {
            buffer.writeFloat(f);
        }
    }

    @Override
    public float[] read(Class<float[]> type, BufferInput buffer, Serializer serializer) {
        float[] floats = new float[buffer.readUnsignedShort()];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = buffer.readFloat();
        }
        return floats;
    }
}

