/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer.lang;

import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.TypeSerializer;

public class BooleanArraySerializer
implements TypeSerializer<boolean[]> {
    @Override
    public void write(boolean[] chars, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(chars.length);
        for (boolean b : chars) {
            buffer.writeBoolean(b);
        }
    }

    @Override
    public boolean[] read(Class<boolean[]> type, BufferInput buffer, Serializer serializer) {
        boolean[] booleans = new boolean[buffer.readUnsignedShort()];
        for (int i = 0; i < booleans.length; ++i) {
            booleans[i] = buffer.readBoolean();
        }
        return booleans;
    }
}

