/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer;

import java.io.Externalizable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kuujo.catalyst.CatalystException;
import net.kuujo.catalyst.serializer.CatalystSerializable;
import net.kuujo.catalyst.serializer.CatalystSerializableSerializer;
import net.kuujo.catalyst.serializer.DefaultTypeSerializerFactory;
import net.kuujo.catalyst.serializer.JdkTypeResolver;
import net.kuujo.catalyst.serializer.PrimitiveTypeResolver;
import net.kuujo.catalyst.serializer.RegistrationException;
import net.kuujo.catalyst.serializer.SerializableTypeResolver;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.TypeSerializer;
import net.kuujo.catalyst.serializer.TypeSerializerFactory;
import net.kuujo.catalyst.serializer.util.ExternalizableSerializer;

public class SerializerRegistry
implements Cloneable {
    private static final SerializableTypeResolver PRIMITIVE_RESOLVER = new PrimitiveTypeResolver();
    private static final SerializableTypeResolver JDK_RESOLVER = new JdkTypeResolver();
    private static final int MAX_TYPE_ID = 65535;
    private static final int RESERVED_MIN = 128;
    private static final int RESERVED_MAX = 255;
    private Map<Class, TypeSerializerFactory> factories;
    private Map<Class, Integer> ids;
    private Map<Integer, Class> types;
    private boolean initialized;

    public SerializerRegistry() {
        this(Collections.EMPTY_LIST);
    }

    public SerializerRegistry(SerializableTypeResolver ... resolvers) {
        this(Arrays.asList(resolvers));
    }

    public SerializerRegistry(Collection<SerializableTypeResolver> resolvers) {
        this(new HashMap<Class, TypeSerializerFactory>(), new HashMap<Class, Integer>(), new HashMap<Integer, Class>());
        PRIMITIVE_RESOLVER.resolve(this);
        JDK_RESOLVER.resolve(this);
        this.initialized = true;
        this.resolve(resolvers);
    }

    private SerializerRegistry(Map<Class, TypeSerializerFactory> factories, Map<Class, Integer> ids, Map<Integer, Class> types) {
        this.factories = factories;
        this.ids = ids;
        this.types = types;
    }

    public SerializerRegistry resolve(SerializableTypeResolver ... resolvers) {
        return this.resolve(resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public SerializerRegistry resolve(Collection<SerializableTypeResolver> resolvers) {
        if (resolvers != null) {
            for (SerializableTypeResolver resolver : resolvers) {
                resolver.resolve(this);
            }
        }
        return this;
    }

    SerializerRegistry copy() {
        return new SerializerRegistry(new HashMap<Class, TypeSerializerFactory>(this.factories), new HashMap<Class, Integer>(this.ids), new HashMap<Integer, Class>(this.types));
    }

    private void validate(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("serializable type ID must be positive");
        }
        if (id > 65535) {
            throw new IllegalArgumentException("serializable type ID must be less than 65536");
        }
        if (this.initialized && id >= 128 && id <= 255) {
            throw new IllegalArgumentException("serializable type IDs 128-255 are reserved");
        }
    }

    public SerializerRegistry register(Class<?> type) {
        if (this.factories.containsKey(type)) {
            throw new RegistrationException("type already registered: " + type);
        }
        SerializeWith serializeWith = type.getAnnotation(SerializeWith.class);
        if (serializeWith != null) {
            if (serializeWith.id() != -1) {
                this.validate(serializeWith.id());
                this.ids.put(type, serializeWith.id());
                this.types.put(serializeWith.id(), type);
            }
            this.factories.put(type, new DefaultTypeSerializerFactory(serializeWith.serializer() != null ? serializeWith.serializer() : CatalystSerializableSerializer.class));
        } else if (CatalystSerializable.class.isAssignableFrom(type)) {
            this.factories.put(type, new DefaultTypeSerializerFactory(CatalystSerializableSerializer.class));
        } else if (Externalizable.class.isAssignableFrom(type)) {
            this.factories.put(type, new DefaultTypeSerializerFactory(ExternalizableSerializer.class));
        } else {
            throw new CatalystException("failed to register serializable type: " + type);
        }
        return this;
    }

    public SerializerRegistry register(Class<?> type, int id) {
        if (this.factories.containsKey(type)) {
            throw new RegistrationException("type already registered: " + type);
        }
        this.validate(id);
        SerializeWith serializeWith = type.getAnnotation(SerializeWith.class);
        if (serializeWith != null && serializeWith.serializer() != null) {
            this.factories.put(type, new DefaultTypeSerializerFactory(serializeWith.serializer()));
        } else if (CatalystSerializable.class.isAssignableFrom(type)) {
            this.factories.put(type, new DefaultTypeSerializerFactory(CatalystSerializableSerializer.class));
        } else if (Externalizable.class.isAssignableFrom(type)) {
            this.factories.put(type, new DefaultTypeSerializerFactory(ExternalizableSerializer.class));
        } else {
            throw new CatalystException("failed to register serializable type: " + type);
        }
        this.ids.put(type, id);
        this.types.put(id, type);
        return this;
    }

    public SerializerRegistry register(Class<?> type, Class<? extends TypeSerializer> serializer) {
        if (this.factories.containsKey(type)) {
            throw new RegistrationException("type already registered: " + type);
        }
        this.factories.put(type, new DefaultTypeSerializerFactory(serializer));
        return this;
    }

    public SerializerRegistry register(Class<?> type, TypeSerializerFactory factory) {
        if (this.factories.containsKey(type)) {
            throw new RegistrationException("type already registered: " + type);
        }
        SerializeWith serializeWith = type.getAnnotation(SerializeWith.class);
        if (serializeWith != null && serializeWith.id() != -1) {
            this.validate(serializeWith.id());
            this.ids.put(type, serializeWith.id());
            this.types.put(serializeWith.id(), type);
        }
        this.factories.put(type, factory);
        return this;
    }

    public SerializerRegistry register(Class<?> type, Class<? extends TypeSerializer> serializer, int id) {
        if (this.factories.containsKey(type)) {
            throw new RegistrationException("type already registered: " + type);
        }
        this.validate(id);
        this.factories.put(type, new DefaultTypeSerializerFactory(serializer));
        this.types.put(id, type);
        this.ids.put(type, id);
        return this;
    }

    public SerializerRegistry register(Class<?> type, TypeSerializerFactory factory, int id) {
        if (this.factories.containsKey(type)) {
            throw new RegistrationException("type already registered: " + type);
        }
        this.validate(id);
        this.factories.put(type, factory);
        this.types.put(id, type);
        this.ids.put(type, id);
        return this;
    }

    public TypeSerializerFactory lookup(Class<?> type) {
        TypeSerializerFactory factory = this.factories.get(type);
        if (factory == null) {
            for (Map.Entry<Class, TypeSerializerFactory> entry : this.factories.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                factory = entry.getValue();
                break;
            }
            if (factory != null) {
                this.factories.put(type, factory);
            } else {
                this.factories.put(type, null);
            }
        }
        return factory;
    }

    Map<Class, Integer> ids() {
        return this.ids;
    }

    Map<Integer, Class> types() {
        return this.types;
    }

    public final SerializerRegistry clone() {
        try {
            SerializerRegistry clone = (SerializerRegistry)super.clone();
            clone.ids = new HashMap<Class, Integer>(this.ids);
            clone.factories = new HashMap<Class, TypeSerializerFactory>(this.factories);
            clone.types = new HashMap<Integer, Class>(this.types);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

