/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.serializer;

import java.io.Externalizable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.kuujo.catalyst.serializer.SerializableTypeResolver;
import net.kuujo.catalyst.serializer.SerializerRegistry;
import net.kuujo.catalyst.serializer.TypeSerializer;
import net.kuujo.catalyst.serializer.collection.ListSerializer;
import net.kuujo.catalyst.serializer.collection.MapSerializer;
import net.kuujo.catalyst.serializer.collection.SetSerializer;
import net.kuujo.catalyst.serializer.util.BigDecimalSerializer;
import net.kuujo.catalyst.serializer.util.BigIntegerSerializer;
import net.kuujo.catalyst.serializer.util.CalendarSerializer;
import net.kuujo.catalyst.serializer.util.DateSerializer;
import net.kuujo.catalyst.serializer.util.ExternalizableSerializer;
import net.kuujo.catalyst.serializer.util.TimeZoneSerializer;

public class JdkTypeResolver
implements SerializableTypeResolver {
    private static final HashMap<Class<?>, Class<? extends TypeSerializer<?>>> SERIALIZERS = new LinkedHashMap(){
        {
            this.put(BigInteger.class, BigIntegerSerializer.class);
            this.put(BigDecimal.class, BigDecimalSerializer.class);
            this.put(Date.class, DateSerializer.class);
            this.put(Calendar.class, CalendarSerializer.class);
            this.put(TimeZone.class, TimeZoneSerializer.class);
            this.put(Map.class, MapSerializer.class);
            this.put(Set.class, SetSerializer.class);
            this.put(List.class, ListSerializer.class);
            this.put(Externalizable.class, ExternalizableSerializer.class);
        }
    };

    @Override
    public void resolve(SerializerRegistry registry) {
        int i = 176;
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : SERIALIZERS.entrySet()) {
            registry.register(entry.getKey(), entry.getValue(), i++);
        }
    }
}

