/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.io.IOException;
import java.io.ObjectOutput;
import net.kuujo.catalyst.buffer.BufferDataOutput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;

public class BufferObjectOutput
extends BufferDataOutput
implements ObjectOutput {
    private final Serializer serializer;

    public BufferObjectOutput(BufferOutput buffer, Serializer serializer) {
        super(buffer);
        if (serializer == null) {
            throw new NullPointerException("serializer cannot be null");
        }
        this.serializer = serializer;
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.serializer.writeObject(obj, this.buffer);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }
}

