/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.transport;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kuujo.catalyst.buffer.BufferAllocator;
import net.kuujo.catalyst.buffer.PooledDirectAllocator;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.transport.Client;
import net.kuujo.catalyst.transport.LocalClient;
import net.kuujo.catalyst.transport.LocalServer;
import net.kuujo.catalyst.transport.LocalServerRegistry;
import net.kuujo.catalyst.transport.Server;
import net.kuujo.catalyst.transport.Transport;
import net.kuujo.catalyst.util.Assert;

public class LocalTransport
implements Transport {
    private final LocalServerRegistry registry;
    private final Serializer serializer;
    private final Map<UUID, LocalClient> clients = new ConcurrentHashMap<UUID, LocalClient>();
    private final Map<UUID, LocalServer> servers = new ConcurrentHashMap<UUID, LocalServer>();

    public LocalTransport(LocalServerRegistry registry) {
        this(registry, new Serializer((BufferAllocator)new PooledDirectAllocator()));
    }

    public LocalTransport(LocalServerRegistry registry, Serializer serializer) {
        if (registry == null) {
            throw new NullPointerException("registry cannot be null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer cannot be null");
        }
        this.registry = registry;
        this.serializer = serializer;
    }

    public Client client(UUID id) {
        return this.clients.computeIfAbsent((UUID)Assert.notNull((Object)id, (String)"id"), i -> new LocalClient(id, this.registry, this.serializer));
    }

    public Server server(UUID id) {
        return this.servers.computeIfAbsent((UUID)Assert.notNull((Object)id, (String)"id"), i -> new LocalServer(id, this.registry, this.serializer));
    }

    public CompletableFuture<Void> close() {
        int i = 0;
        CompletableFuture[] futures = new CompletableFuture[this.clients.size() + this.servers.size()];
        for (Client client : this.clients.values()) {
            futures[i++] = client.close();
        }
        for (Server server : this.servers.values()) {
            futures[i++] = server.close();
        }
        return CompletableFuture.allOf(futures);
    }
}

