/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.transport;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Connection;
import net.kuujo.catalyst.transport.LocalConnection;
import net.kuujo.catalyst.transport.LocalServerRegistry;
import net.kuujo.catalyst.transport.Server;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.SingleThreadContext;

public class LocalServer
implements Server {
    private final UUID id;
    private final LocalServerRegistry registry;
    private final Context context;
    private final Set<LocalConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Address address;
    private volatile ListenerHolder listener;

    public LocalServer(UUID id, LocalServerRegistry registry, Serializer serializer) {
        this.id = id;
        this.registry = registry;
        this.context = new SingleThreadContext("test-" + id.toString(), serializer.clone());
    }

    public UUID id() {
        return this.id;
    }

    private Context getContext() {
        Context context = Context.currentContext();
        if (context == null) {
            throw new IllegalStateException("not on a Catalyst thread");
        }
        return context;
    }

    CompletableFuture<Void> connect(LocalConnection connection) {
        LocalConnection localConnection = new LocalConnection(connection.id(), this.context, this.connections);
        connection.connect(localConnection);
        localConnection.connect(connection);
        return CompletableFuture.runAsync(() -> this.listener.listener.accept(localConnection), this.listener.context.executor());
    }

    public synchronized CompletableFuture<Void> listen(Address address, Consumer<Connection> listener) {
        Assert.notNull((Object)address, (String)"address");
        Assert.notNull(listener, (String)"listener");
        if (this.address != null) {
            if (!this.address.equals((Object)address)) {
                throw new IllegalStateException(String.format("already listening at %s", this.address));
            }
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.registry.register(address, this);
        Context context = this.getContext();
        this.address = address;
        this.listener = new ListenerHolder(listener, context);
        context.execute(() -> future.complete(null));
        return future;
    }

    public synchronized CompletableFuture<Void> close() {
        if (this.address == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.registry.unregister(this.address);
        this.address = null;
        this.listener = null;
        Context context = this.getContext();
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (LocalConnection connection : this.connections) {
            futures[i++] = connection.close();
        }
        CompletableFuture.allOf(futures).thenRunAsync(() -> future.complete(null), context.executor());
        return future;
    }

    private static class ListenerHolder {
        private final Consumer<Connection> listener;
        private final Context context;

        private ListenerHolder(Consumer<Connection> listener, Context context) {
            this.listener = listener;
            this.context = context;
        }
    }
}

