/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.transport;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Client;
import net.kuujo.catalyst.transport.Connection;
import net.kuujo.catalyst.transport.LocalConnection;
import net.kuujo.catalyst.transport.LocalServer;
import net.kuujo.catalyst.transport.LocalServerRegistry;
import net.kuujo.catalyst.transport.TransportException;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Futures;
import net.kuujo.catalyst.util.concurrent.SingleThreadContext;

public class LocalClient
implements Client {
    private final UUID id;
    private final LocalServerRegistry registry;
    private final Context context;
    private final Set<LocalConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());

    public LocalClient(UUID id, LocalServerRegistry registry, Serializer serializer) {
        this.id = id;
        this.registry = registry;
        this.context = new SingleThreadContext("test-" + id.toString(), serializer.clone());
    }

    public UUID id() {
        return this.id;
    }

    private Context getContext() {
        Context context = Context.currentContext();
        Assert.state((context != null ? 1 : 0) != 0, (String)"not on a Catalyst thread", (Object[])new Object[0]);
        return context;
    }

    public CompletableFuture<Connection> connect(Address address) {
        Assert.notNull((Object)address, (String)"address");
        Context context = this.getContext();
        LocalServer server = this.registry.get(address);
        if (server == null) {
            return Futures.exceptionalFutureAsync((Throwable)new TransportException("failed to connect"), (Executor)context.executor());
        }
        LocalConnection connection = new LocalConnection(this.id, this.context, this.connections);
        this.connections.add(connection);
        return server.connect(connection).thenApplyAsync(v -> connection, context.executor());
    }

    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Context context = this.getContext();
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (LocalConnection connection : this.connections) {
            futures[i++] = connection.close();
        }
        CompletableFuture.allOf(futures).thenRunAsync(() -> future.complete(null), context.executor());
        return future;
    }
}

