/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.jodah.concurrentunit.ConcurrentTestCase;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Client;
import net.kuujo.catalyst.transport.LocalServerRegistry;
import net.kuujo.catalyst.transport.LocalTransport;
import net.kuujo.catalyst.transport.Server;
import net.kuujo.catalyst.util.concurrent.SingleThreadContext;
import org.testng.annotations.Test;

@Test
public class LocalTransportTest
extends ConcurrentTestCase {
    public void testSendReceive() throws Throwable {
        LocalServerRegistry registry = new LocalServerRegistry();
        LocalTransport clientTransport = new LocalTransport(registry);
        LocalTransport serverTransport = new LocalTransport(registry);
        Server server = serverTransport.server(UUID.randomUUID());
        Client client = clientTransport.client(UUID.randomUUID());
        SingleThreadContext context = new SingleThreadContext("test-thread-%d", new Serializer());
        context.executor().execute(() -> {
            try {
                server.listen(new Address(new InetSocketAddress(InetAddress.getByName("localhost"), 5555)), connection -> connection.handler(String.class, message -> {
                    this.threadAssertEquals("Hello world!", message);
                    return CompletableFuture.completedFuture("Hello world back!");
                })).thenRun(() -> ((LocalTransportTest)this).resume());
            }
            catch (UnknownHostException e) {
                this.threadFail(e);
            }
        });
        this.await();
        context.executor().execute(() -> {
            try {
                client.connect(new Address(new InetSocketAddress(InetAddress.getByName("localhost"), 5555))).thenAccept(connection -> connection.send((Object)"Hello world!").thenAccept(response -> {
                    this.threadAssertEquals("Hello world back!", response);
                    this.resume();
                }));
            }
            catch (UnknownHostException e) {
                this.threadFail(e);
            }
        });
        this.await();
    }
}

