/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kuujo.catalyst.util.ReferenceCounted;
import net.kuujo.catalyst.util.ReferenceFactory;
import net.kuujo.catalyst.util.ReferenceManager;

public class ReferencePool<T extends ReferenceCounted<?>>
implements ReferenceManager<T>,
AutoCloseable {
    private final ReferenceFactory<T> factory;
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();
    private volatile boolean closed;

    public ReferencePool(ReferenceFactory<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory cannot be null");
        }
        this.factory = factory;
    }

    public T acquire() {
        if (this.closed) {
            throw new IllegalStateException("pool closed");
        }
        ReferenceCounted reference = (ReferenceCounted)this.pool.poll();
        if (reference == null) {
            reference = this.factory.createReference(this);
        }
        reference.acquire();
        return (T)reference;
    }

    @Override
    public void release(T reference) {
        if (!this.closed) {
            this.pool.add(reference);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("pool closed");
        }
        this.closed = true;
        for (ReferenceCounted reference : this.pool) {
            reference.close();
        }
    }
}

