/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.nio.ByteOrder;
import net.kuujo.catalyst.buffer.AbstractBuffer;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.Bytes;
import net.kuujo.catalyst.util.ReferenceManager;

public class SwappedBuffer
extends AbstractBuffer {
    private final Buffer root;

    SwappedBuffer(Buffer root, Bytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.root = root;
    }

    public SwappedBuffer(Buffer buffer, long offset, long initialCapacity, long maxCapacity, ReferenceManager<Buffer> referenceManager) {
        super(buffer.bytes().order(buffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN), offset, initialCapacity, maxCapacity, referenceManager);
        this.root = buffer instanceof SwappedBuffer ? ((SwappedBuffer)buffer).root : buffer;
        this.root.acquire();
    }

    public Buffer root() {
        return this.root;
    }

    @Override
    public boolean isDirect() {
        return this.root.isDirect();
    }

    @Override
    public boolean isFile() {
        return this.root.isFile();
    }

    @Override
    public boolean isReadOnly() {
        return this.root.isReadOnly();
    }

    @Override
    public Buffer compact() {
        this.root.compact();
        return this;
    }

    @Override
    protected void compact(long from, long to, long length) {
        if (this.root instanceof AbstractBuffer) {
            ((AbstractBuffer)this.root).compact(from, to, length);
        }
    }

    @Override
    public Buffer acquire() {
        this.root.acquire();
        return this;
    }

    @Override
    public boolean release() {
        return this.root.release();
    }

    @Override
    public void close() {
        this.root.release();
    }
}

