/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import net.kuujo.catalyst.buffer.AbstractBuffer;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.Bytes;

public class SlicedBuffer
extends AbstractBuffer {
    private final Buffer root;

    public SlicedBuffer(Buffer root, Bytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.root = root;
        root.acquire();
    }

    public Buffer root() {
        return this.root;
    }

    @Override
    public boolean isDirect() {
        return this.root.isDirect();
    }

    @Override
    protected void compact(long from, long to, long length) {
        if (this.root instanceof AbstractBuffer) {
            ((AbstractBuffer)this.root).compact(from, to, length);
        }
    }

    @Override
    public boolean isFile() {
        return this.root.isFile();
    }

    @Override
    public boolean isReadOnly() {
        return this.root.isReadOnly();
    }

    @Override
    public Buffer compact() {
        return null;
    }

    @Override
    public Buffer acquire() {
        this.root.acquire();
        return this;
    }

    @Override
    public boolean release() {
        return this.root.release();
    }

    @Override
    public void close() {
        this.root.release();
    }
}

