/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.nio.charset.StandardCharsets;
import net.kuujo.catalyst.buffer.AbstractBytes;
import net.kuujo.catalyst.buffer.Bytes;
import net.kuujo.catalyst.buffer.NativeBytes;
import net.kuujo.catalyst.buffer.util.HeapMemory;

public class HeapBytes
extends AbstractBytes {
    protected HeapMemory memory;

    public static HeapBytes allocate(long size) {
        if (size > 0x7FFFFFFAL) {
            throw new IllegalArgumentException("size cannot for HeapBytes cannot be greater than 2147483642");
        }
        return new HeapBytes(HeapMemory.allocate(size));
    }

    public static HeapBytes wrap(byte[] bytes) {
        return new HeapBytes(HeapMemory.wrap(bytes));
    }

    protected HeapBytes(HeapMemory memory) {
        this.memory = memory;
    }

    public HeapBytes copy() {
        return new HeapBytes(this.memory.copy());
    }

    public byte[] array() {
        return this.memory.array();
    }

    public HeapBytes reset(byte[] array) {
        this.memory.reset(array);
        return this;
    }

    @Override
    public long size() {
        return this.memory.size();
    }

    @Override
    public Bytes resize(long newSize) {
        this.memory = this.memory.allocator().reallocate(this.memory, newSize);
        return this;
    }

    @Override
    public Bytes zero() {
        return this.zero(0L, this.memory.size());
    }

    @Override
    public Bytes zero(long offset) {
        return this.zero(offset, this.memory.size() - offset);
    }

    @Override
    public Bytes zero(long offset, long length) {
        this.memory.unsafe().setMemory(this.memory.array(), this.memory.address(offset), length, (byte)0);
        return this;
    }

    @Override
    public Bytes read(long position, Bytes bytes, long offset, long length) {
        this.checkRead(position, length);
        if (bytes instanceof HeapBytes) {
            this.memory.unsafe().copyMemory(this.memory.array(), this.memory.address(position), ((HeapBytes)bytes).memory.array(), ((HeapBytes)bytes).memory.address(offset), length);
        } else if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(this.memory.array(), this.memory.address(position), null, ((NativeBytes)bytes).memory.address(offset), length);
        } else {
            int i = 0;
            while ((long)i < length) {
                bytes.writeByte(offset + (long)i, this.memory.getByte(position + (long)i));
                ++i;
            }
        }
        return this;
    }

    @Override
    public Bytes read(long position, byte[] bytes, long offset, long length) {
        this.checkRead(position, length);
        this.memory.unsafe().copyMemory(this.memory.array(), this.memory.address(position), bytes, this.memory.address(offset), length);
        return this;
    }

    @Override
    public int readByte(long offset) {
        this.checkRead(offset, 1L);
        return this.memory.getByte(offset);
    }

    @Override
    public int readUnsignedByte(long offset) {
        this.checkRead(offset, 1L);
        return this.memory.getByte(offset) & 0xFF;
    }

    @Override
    public char readChar(long offset) {
        this.checkRead(offset, 2L);
        return this.memory.getChar(offset);
    }

    @Override
    public short readShort(long offset) {
        this.checkRead(offset, 2L);
        return this.memory.getShort(offset);
    }

    @Override
    public int readUnsignedShort(long offset) {
        this.checkRead(offset, 2L);
        return this.memory.getShort(offset) & 0xFFFF;
    }

    @Override
    public int readMedium(long offset) {
        this.checkRead(offset, 3L);
        return this.memory.getByte(offset) << 16 | (this.memory.getByte(offset + 1L) & 0xFF) << 8 | this.memory.getByte(offset + 2L) & 0xFF;
    }

    @Override
    public int readUnsignedMedium(long offset) {
        this.checkRead(offset, 3L);
        return (this.memory.getByte(offset) & 0xFF) << 16 | (this.memory.getByte(offset + 1L) & 0xFF) << 8 | this.memory.getByte(offset + 2L) & 0xFF;
    }

    @Override
    public int readInt(long offset) {
        this.checkRead(offset, 4L);
        return this.memory.getInt(offset);
    }

    @Override
    public long readUnsignedInt(long offset) {
        this.checkRead(offset, 4L);
        return (long)this.memory.getInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public long readLong(long offset) {
        this.checkRead(offset, 8L);
        return this.memory.getLong(offset);
    }

    @Override
    public float readFloat(long offset) {
        this.checkRead(offset, 4L);
        return this.memory.getFloat(offset);
    }

    @Override
    public double readDouble(long offset) {
        this.checkRead(offset, 8L);
        return this.memory.getDouble(offset);
    }

    @Override
    public boolean readBoolean(long offset) {
        this.checkRead(offset, 1L);
        return this.memory.getByte(offset) == 1;
    }

    @Override
    public String readString(long offset) {
        byte[] bytes = new byte[this.readUnsignedShort(offset)];
        this.read(offset + 2L, bytes, 0L, (long)bytes.length);
        return new String(bytes);
    }

    @Override
    public String readUTF8(long offset) {
        byte[] bytes = new byte[this.readUnsignedShort(offset)];
        this.read(offset + 2L, bytes, 0L, (long)bytes.length);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public Bytes write(long position, Bytes bytes, long offset, long length) {
        this.checkWrite(position, length);
        if (bytes.size() < length) {
            throw new IllegalArgumentException("length is greater than provided byte array size");
        }
        if (bytes instanceof HeapBytes) {
            this.memory.unsafe().copyMemory(((HeapBytes)bytes).memory.array(), ((HeapBytes)bytes).memory.address(offset), this.memory.array(), this.memory.address(position), length);
        } else if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(null, ((NativeBytes)bytes).memory.address(offset), this.memory.array(), this.memory.address(position), length);
        } else {
            int i = 0;
            while ((long)i < length) {
                this.memory.putByte(position + (long)i, (byte)bytes.readByte(offset + (long)i));
                ++i;
            }
        }
        return this;
    }

    @Override
    public Bytes write(long position, byte[] bytes, long offset, long length) {
        this.checkWrite(position, length);
        if ((long)bytes.length < length) {
            throw new IllegalArgumentException("length is greater than provided byte array length");
        }
        this.memory.unsafe().copyMemory(bytes, this.memory.address(offset), this.memory.array(), this.memory.address(position), length);
        return this;
    }

    @Override
    public Bytes writeByte(long offset, int b) {
        this.checkWrite(offset, 1L);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeUnsignedByte(long offset, int b) {
        this.checkWrite(offset, 1L);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeChar(long offset, char c) {
        this.checkWrite(offset, 2L);
        this.memory.putChar(offset, c);
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short s) {
        this.checkWrite(offset, 2L);
        this.memory.putShort(offset, s);
        return this;
    }

    @Override
    public Bytes writeUnsignedShort(long offset, int s) {
        this.checkWrite(offset, 2L);
        this.memory.putShort(offset, (short)s);
        return this;
    }

    @Override
    public Bytes writeMedium(long offset, int m) {
        this.memory.putByte(offset, (byte)(m >>> 16));
        this.memory.putByte(offset + 1L, (byte)(m >>> 8));
        this.memory.putByte(offset + 2L, (byte)m);
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(long offset, int m) {
        return this.writeMedium(offset, m);
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.checkWrite(offset, 4L);
        this.memory.putInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(long offset, long i) {
        this.checkWrite(offset, 4L);
        this.memory.putInt(offset, (int)i);
        return this;
    }

    @Override
    public Bytes writeLong(long offset, long l) {
        this.checkWrite(offset, 8L);
        this.memory.putLong(offset, l);
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float f) {
        this.checkWrite(offset, 4L);
        this.memory.putFloat(offset, f);
        return this;
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        this.checkWrite(offset, 8L);
        this.memory.putDouble(offset, d);
        return this;
    }

    @Override
    public Bytes writeBoolean(long offset, boolean b) {
        this.checkWrite(offset, 1L);
        this.memory.putByte(offset, b ? (byte)1 : 0);
        return this;
    }

    @Override
    public Bytes writeString(long offset, String s) {
        byte[] bytes = s.getBytes();
        return (Bytes)this.writeUnsignedShort(offset, bytes.length).write(offset + 2L, bytes, 0L, (long)bytes.length);
    }

    @Override
    public Bytes writeUTF8(long offset, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return (Bytes)this.writeUnsignedShort(offset, bytes.length).write(offset + 2L, bytes, 0L, (long)bytes.length);
    }

    @Override
    public Bytes flush() {
        return this;
    }

    @Override
    public void close() {
        this.flush();
        super.close();
    }
}

