/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.BufferPool;
import net.kuujo.catalyst.buffer.HeapBuffer;
import net.kuujo.catalyst.buffer.HeapBytes;
import net.kuujo.catalyst.util.ReferenceFactory;
import net.kuujo.catalyst.util.ReferenceManager;

public class HeapBufferPool
extends BufferPool {
    public HeapBufferPool() {
        super(new HeapBufferFactory());
    }

    @Override
    public void release(Buffer reference) {
        reference.rewind();
        super.release(reference);
    }

    private static class HeapBufferFactory
    implements ReferenceFactory<Buffer> {
        private HeapBufferFactory() {
        }

        @Override
        public Buffer createReference(ReferenceManager<Buffer> manager) {
            HeapBuffer buffer = new HeapBuffer(HeapBytes.allocate(1024L), manager);
            buffer.reset(0L, 1024L, Long.MAX_VALUE);
            return buffer;
        }
    }
}

