/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.BufferPool;
import net.kuujo.catalyst.buffer.DirectBuffer;
import net.kuujo.catalyst.buffer.DirectBytes;
import net.kuujo.catalyst.util.ReferenceFactory;
import net.kuujo.catalyst.util.ReferenceManager;

public class DirectBufferPool
extends BufferPool {
    public DirectBufferPool() {
        super(new DirectBufferFactory());
    }

    @Override
    public void release(Buffer reference) {
        reference.rewind();
        super.release(reference);
    }

    private static class DirectBufferFactory
    implements ReferenceFactory<Buffer> {
        private DirectBufferFactory() {
        }

        @Override
        public Buffer createReference(ReferenceManager<Buffer> manager) {
            DirectBuffer buffer = new DirectBuffer(DirectBytes.allocate(1024L), manager);
            buffer.reset(0L, 1024L, Long.MAX_VALUE);
            return buffer;
        }
    }
}

