/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.storage;

import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.RaftEntry;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.ReferenceManager;

public abstract class TimestampedEntry<T extends TimestampedEntry<T>>
extends RaftEntry<T> {
    private long timestamp;

    protected TimestampedEntry() {
    }

    protected TimestampedEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return (T)((Object)this);
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.timestamp);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.timestamp = buffer.readLong();
    }

    public String toString() {
        return String.format("%s[index=%d, term=%d, timestamp=%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.timestamp);
    }
}

