/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.storage;

import java.util.UUID;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.TimestampedEntry;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=303)
public class RegisterEntry
extends TimestampedEntry<RegisterEntry> {
    private UUID connection;
    private long timeout;

    public RegisterEntry() {
    }

    public RegisterEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public UUID getConnection() {
        return this.connection;
    }

    public RegisterEntry setConnection(UUID connection) {
        this.connection = (UUID)Assert.notNull((Object)connection, (String)"connection");
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RegisterEntry setTimeout(long timeout) {
        this.timeout = (Long)Assert.argNot((Object)timeout, (timeout <= 0L ? 1 : 0) != 0, (String)"timeout must be positive", (Object[])new Object[0]);
        return this;
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.timeout);
        serializer.writeObject((Object)this.connection, buffer);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.timeout = buffer.readLong();
        this.connection = (UUID)serializer.readObject(buffer);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, connection=%s, timeout=%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getConnection(), this.getTimestamp());
    }
}

