/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.storage;

import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.SessionEntry;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=304)
public class KeepAliveEntry
extends SessionEntry<KeepAliveEntry> {
    private long commandSequence;
    private long eventVersion;
    private long eventSequence;

    public KeepAliveEntry() {
    }

    public KeepAliveEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public long getCommandSequence() {
        return this.commandSequence;
    }

    public KeepAliveEntry setCommandSequence(long commandSequence) {
        this.commandSequence = commandSequence;
        return this;
    }

    public long getEventVersion() {
        return this.eventVersion;
    }

    public KeepAliveEntry setEventVersion(long eventVersion) {
        this.eventVersion = eventVersion;
        return this;
    }

    public long getEventSequence() {
        return this.eventSequence;
    }

    public KeepAliveEntry setEventSequence(long eventSequence) {
        this.eventSequence = eventSequence;
        return this;
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.commandSequence = buffer.readLong();
        this.eventVersion = buffer.readLong();
        this.eventSequence = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.commandSequence);
        buffer.writeLong(this.eventVersion);
        buffer.writeLong(this.eventSequence);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, session=%d, commandSequence=%d, eventVersion=%d, eventSequence=%d, timestamp=%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getSession(), this.getCommandSequence(), this.getEventVersion(), this.getEventSequence(), this.getTimestamp());
    }
}

