/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kuujo.catalog.client.Operation;
import net.kuujo.catalog.client.error.ApplicationException;
import net.kuujo.catalog.server.Commit;
import net.kuujo.catalog.server.StateMachineExecutor;
import net.kuujo.catalog.server.state.ServerStateMachineContext;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.concurrent.ComposableFuture;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Scheduled;
import org.slf4j.Logger;

class ServerStateMachineExecutor
implements StateMachineExecutor {
    private final Context executor;
    private final ServerStateMachineContext context;
    private final List<ServerScheduledTask> tasks = new ArrayList<ServerScheduledTask>();
    private final List<ServerScheduledTask> complete = new ArrayList<ServerScheduledTask>();
    private final Map<Class, Function> operations = new HashMap<Class, Function>();
    private Function allOperation;
    private long timestamp;

    ServerStateMachineExecutor(Context context) {
        this.executor = context;
        this.context = new ServerStateMachineContext();
    }

    long timestamp() {
        return this.timestamp;
    }

    @Override
    public ServerStateMachineContext context() {
        return this.context;
    }

    public Logger logger() {
        return this.executor.logger();
    }

    public Serializer serializer() {
        return this.executor.serializer();
    }

    public Executor executor() {
        return this.executor.executor();
    }

    <T extends Operation<U>, U> CompletableFuture<U> execute(Commit<T> commit) {
        ComposableFuture future = new ComposableFuture();
        this.executor.executor().execute(() -> {
            this.context.update(commit.index(), commit.time());
            Function function = this.operations.get(commit.type());
            if (function == null) {
                for (Map.Entry<Class, Function> entry : this.operations.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(commit.type())) continue;
                    function = entry.getValue();
                    break;
                }
                if (function != null) {
                    this.operations.put(commit.type(), function);
                }
            }
            if (function == null && (function = this.allOperation) != null) {
                this.operations.put(commit.type(), function);
            }
            if (function == null) {
                future.completeExceptionally((Throwable)new IllegalStateException("unknown state machine operation: " + commit.type()));
            } else {
                try {
                    Object result = function.apply(commit);
                    if (result instanceof CompletableFuture) {
                        ((CompletableFuture)result).whenCompleteAsync((BiConsumer)future, this.executor.executor());
                    } else if (result instanceof Future) {
                        future.complete(((Future)result).get());
                    } else {
                        future.complete(result);
                    }
                }
                catch (Exception e) {
                    future.completeExceptionally((Throwable)new ApplicationException("An application error occurred", new Object[]{e}));
                }
            }
        });
        return future;
    }

    void tick(long timestamp) {
        this.timestamp = Math.max(this.timestamp, timestamp);
        if (!this.tasks.isEmpty()) {
            ServerScheduledTask task;
            Iterator<ServerScheduledTask> iterator = this.tasks.iterator();
            while (iterator.hasNext() && (task = iterator.next()).complete(this.timestamp)) {
                this.executor.executor().execute(() -> {
                    this.context.update(this.context.version(), Instant.ofEpochMilli(task.time));
                    task.execute();
                });
                this.complete.add(task);
                iterator.remove();
            }
            for (ServerScheduledTask task2 : this.complete) {
                task2.reschedule();
            }
            this.complete.clear();
        }
    }

    public CompletableFuture<Void> execute(Runnable callback) {
        return this.executor.execute(callback);
    }

    public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        return this.executor.execute(callback);
    }

    public Scheduled schedule(Runnable callback, Duration delay) {
        return new ServerScheduledTask(callback, delay.toMillis()).schedule();
    }

    public Scheduled schedule(Runnable callback, Duration initialDelay, Duration interval) {
        return new ServerScheduledTask(callback, initialDelay.toMillis(), interval.toMillis()).schedule();
    }

    @Override
    public StateMachineExecutor register(Function<Commit<? extends Operation<?>>, ?> callback) {
        this.allOperation = (Function)Assert.notNull(callback, (String)"callback");
        return this;
    }

    @Override
    public <T extends Operation<Void>> StateMachineExecutor register(Class<T> type, Consumer<Commit<T>> callback) {
        Assert.notNull(type, (String)"type");
        Assert.notNull(callback, (String)"callback");
        this.operations.put(type, commit -> {
            callback.accept((Commit)commit);
            return null;
        });
        return this;
    }

    @Override
    public <T extends Operation<U>, U> StateMachineExecutor register(Class<T> type, Function<Commit<T>, U> callback) {
        Assert.notNull(type, (String)"type");
        Assert.notNull(callback, (String)"callback");
        this.operations.put(type, callback);
        return this;
    }

    @Override
    public void close() {
        this.executor.close();
    }

    private class ServerScheduledTask
    implements Scheduled {
        private final long delay;
        private final long interval;
        private final Runnable callback;
        private long time;

        private ServerScheduledTask(Runnable callback, long delay) {
            this(callback, delay, 0L);
        }

        private ServerScheduledTask(Runnable callback, long delay, long interval) {
            this.delay = delay;
            this.interval = interval;
            this.callback = callback;
            this.time = ServerStateMachineExecutor.this.context.now().toEpochMilli() + delay;
        }

        private Scheduled schedule() {
            if (!ServerStateMachineExecutor.this.tasks.isEmpty()) {
                int i;
                int l = 0;
                int u = ServerStateMachineExecutor.this.tasks.size() - 1;
                while (true) {
                    i = (u + l) / 2;
                    long t = ((ServerScheduledTask)((ServerStateMachineExecutor)ServerStateMachineExecutor.this).tasks.get((int)i)).time;
                    if (t == this.time) {
                        ServerStateMachineExecutor.this.tasks.add(i, this);
                        return this;
                    }
                    if (t < this.time) {
                        l = i + 1;
                        if (l <= u) continue;
                        ServerStateMachineExecutor.this.tasks.add(i + 1, this);
                        return this;
                    }
                    u = i - 1;
                    if (l > u) break;
                }
                ServerStateMachineExecutor.this.tasks.add(i, this);
                return this;
            }
            ServerStateMachineExecutor.this.tasks.add(this);
            return this;
        }

        private void reschedule() {
            if (this.interval > 0L) {
                this.time = ServerStateMachineExecutor.this.timestamp + this.delay;
                this.schedule();
            }
        }

        private boolean complete(long timestamp) {
            return timestamp >= this.time;
        }

        private synchronized void execute() {
            this.callback.run();
        }

        public synchronized void cancel() {
            ServerStateMachineExecutor.this.tasks.remove(this);
        }
    }
}

