/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.time.Clock;
import java.time.Instant;
import net.kuujo.catalog.server.StateMachineContext;
import net.kuujo.catalog.server.state.ServerClock;
import net.kuujo.catalog.server.state.ServerSessionManager;

class ServerStateMachineContext
implements StateMachineContext {
    private long version;
    private final ServerClock clock = new ServerClock();
    private final ServerSessionManager sessions = new ServerSessionManager(this);

    ServerStateMachineContext() {
    }

    void update(long index, Instant instant) {
        this.version = index;
        this.clock.set(instant);
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Instant now() {
        return this.clock.instant();
    }

    @Override
    public ServerSessionManager sessions() {
        return this.sessions;
    }

    public String toString() {
        return String.format("%s[version=%d, time=%s]", this.getClass().getSimpleName(), this.version, this.clock);
    }
}

