/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kuujo.catalog.client.error.InternalException;
import net.kuujo.catalog.client.error.UnknownSessionException;
import net.kuujo.catalog.server.StateMachine;
import net.kuujo.catalog.server.state.ServerCommit;
import net.kuujo.catalog.server.state.ServerCommitCleaner;
import net.kuujo.catalog.server.state.ServerCommitPool;
import net.kuujo.catalog.server.state.ServerSession;
import net.kuujo.catalog.server.state.ServerStateMachineExecutor;
import net.kuujo.catalog.server.storage.CommandEntry;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.KeepAliveEntry;
import net.kuujo.catalog.server.storage.NoOpEntry;
import net.kuujo.catalog.server.storage.OperationEntry;
import net.kuujo.catalog.server.storage.QueryEntry;
import net.kuujo.catalog.server.storage.RegisterEntry;
import net.kuujo.catalyst.util.concurrent.ComposableFuture;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Futures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerStateMachine
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerStateMachine.class);
    private final StateMachine stateMachine;
    private final ServerStateMachineExecutor executor;
    private final ServerCommitPool commits;
    private long lastApplied;

    ServerStateMachine(StateMachine stateMachine, ServerCommitCleaner cleaner, Context context) {
        this.stateMachine = stateMachine;
        this.executor = new ServerStateMachineExecutor(context);
        this.commits = new ServerCommitPool(cleaner, this.executor.context().sessions());
        this.init();
    }

    private void init() {
        this.stateMachine.init(this.executor.context());
        this.stateMachine.configure(this.executor);
    }

    ServerStateMachineExecutor executor() {
        return this.executor;
    }

    long getLastApplied() {
        return this.lastApplied;
    }

    private void setLastApplied(long lastApplied) {
        if (lastApplied < this.lastApplied) {
            throw new IllegalArgumentException("lastApplied index must be greater than previous lastApplied index");
        }
        if (lastApplied > this.lastApplied) {
            this.lastApplied = lastApplied;
            for (ServerSession session : this.executor.context().sessions().sessions.values()) {
                session.setVersion(lastApplied);
            }
        }
    }

    private Context getContext() {
        Context context = Context.currentContext();
        if (context == null) {
            throw new IllegalStateException("must be called from a Catalyst thread");
        }
        return context;
    }

    CompletableFuture<?> apply(Entry entry) {
        try {
            if (entry instanceof CommandEntry) {
                CompletableFuture<Object> completableFuture = this.apply((CommandEntry)entry);
                return completableFuture;
            }
            if (entry instanceof QueryEntry) {
                CompletableFuture<Object> completableFuture = this.apply((QueryEntry)entry);
                return completableFuture;
            }
            if (entry instanceof RegisterEntry) {
                CompletableFuture<Long> completableFuture = this.apply((RegisterEntry)entry);
                return completableFuture;
            }
            if (entry instanceof KeepAliveEntry) {
                CompletableFuture<Void> completableFuture = this.apply((KeepAliveEntry)entry);
                return completableFuture;
            }
            if (entry instanceof NoOpEntry) {
                CompletableFuture<Long> completableFuture = this.apply((NoOpEntry)entry);
                return completableFuture;
            }
            CompletableFuture completableFuture = Futures.exceptionalFuture((Throwable)new InternalException("unknown state machine operation", new Object[0]));
            return completableFuture;
        }
        finally {
            this.setLastApplied(entry.getIndex());
        }
    }

    private CompletableFuture<Long> apply(RegisterEntry entry) {
        ServerSession session = this.executor.context().sessions().registerSession(entry.getIndex(), entry.getConnection(), entry.getTimeout()).setTimestamp(entry.getTimestamp());
        Context context = this.getContext();
        long index = entry.getIndex();
        ComposableFuture future = new ComposableFuture();
        this.executor.executor().execute(() -> this.lambda$apply$24(session, context, (CompletableFuture)future, index));
        this.expireSessions(entry.getTimestamp());
        this.executor.tick(entry.getTimestamp());
        return future;
    }

    private CompletableFuture<Void> apply(KeepAliveEntry entry) {
        CompletableFuture future;
        ServerSession session = this.executor.context().sessions().getSession(entry.getSession());
        if (session == null) {
            LOGGER.warn("Unknown session: " + entry.getSession());
            future = Futures.exceptionalFuture((Throwable)new UnknownSessionException("unknown session: " + entry.getSession(), new Object[0]));
        } else {
            Context context = this.getContext();
            session.setTimestamp(entry.getTimestamp()).clearResponses(entry.getCommandSequence()).clearEvents(entry.getEventVersion(), entry.getEventSequence());
            future = new CompletableFuture();
            context.execute(() -> future.complete(null));
        }
        this.expireSessions(entry.getTimestamp());
        this.executor.tick(entry.getTimestamp());
        return future;
    }

    private CompletableFuture<Object> apply(CommandEntry entry) {
        CompletableFuture future;
        ServerSession session = this.executor.context().sessions().getSession(entry.getSession());
        if (session == null) {
            LOGGER.warn("Unknown session: " + entry.getSession());
            future = Futures.exceptionalFuture((Throwable)new UnknownSessionException("unknown session " + entry.getSession(), new Object[0]));
        } else if (entry.getSequence() > session.nextSequence()) {
            future = new CompletableFuture();
            Context context = this.getContext();
            session.registerCommand(entry.getSequence(), () -> this.executeCommand(entry, session, future, context));
        } else if (entry.getSequence() < session.nextSequence()) {
            future = new CompletableFuture();
            Context context = this.getContext();
            long sequence = entry.getSequence();
            this.executor.executor().execute(() -> {
                Object response = session.getResponse(sequence);
                if (response == null) {
                    context.executor().execute(() -> future.complete(null));
                } else if (response instanceof Throwable) {
                    context.executor().execute(() -> future.completeExceptionally((Throwable)response));
                } else {
                    context.executor().execute(() -> future.complete(response));
                }
            });
        } else {
            future = new CompletableFuture();
            this.executeCommand(entry, session, future, this.getContext());
        }
        return future;
    }

    private CompletableFuture<Object> executeCommand(CommandEntry entry, ServerSession session, CompletableFuture<Object> future, Context context) {
        context.checkThread();
        long sequence = entry.getSequence();
        this.executor.execute(this.commits.acquire(entry)).whenComplete((result, error) -> {
            if (error == null) {
                session.registerResponse(sequence, result);
                context.execute(() -> future.complete(result));
            } else {
                session.registerResponse(sequence, error);
                context.execute(() -> future.completeExceptionally((Throwable)error));
            }
        });
        session.setTimestamp(entry.getTimestamp()).setSequence(sequence);
        this.executor.tick(entry.getTimestamp());
        return future;
    }

    private CompletableFuture<Object> apply(QueryEntry entry) {
        ServerSession session = this.executor.context().sessions().getSession(entry.getSession());
        if (session == null) {
            LOGGER.warn("Unknown session: " + entry.getSession());
            return Futures.exceptionalFuture((Throwable)new UnknownSessionException("unknown session " + entry.getSession(), new Object[0]));
        }
        if (session.getVersion() < entry.getVersion()) {
            ComposableFuture future = new ComposableFuture();
            Context context = this.getContext();
            ServerCommit commit = this.commits.acquire((OperationEntry)((Object)entry.setTimestamp(this.executor.timestamp())));
            session.registerQuery(entry.getVersion(), () -> {
                context.checkThread();
                this.executeQuery(commit, (CompletableFuture<Object>)future, context);
            });
            return future;
        }
        return this.executeQuery(this.commits.acquire((OperationEntry)((Object)entry.setTimestamp(this.executor.timestamp()))), new CompletableFuture<Object>(), this.getContext());
    }

    private CompletableFuture<Object> executeQuery(ServerCommit commit, CompletableFuture<Object> future, Context context) {
        this.executor.execute(commit).whenComplete((result, error) -> {
            if (error == null) {
                context.execute(() -> future.complete(result));
            } else {
                context.execute(() -> future.completeExceptionally((Throwable)error));
            }
        });
        return future;
    }

    private CompletableFuture<Long> apply(NoOpEntry entry) {
        for (ServerSession session : this.executor.context().sessions().sessions.values()) {
            session.setTimestamp(entry.getTimestamp());
        }
        return Futures.completedFutureAsync((Object)entry.getIndex(), (Executor)this.getContext().executor());
    }

    private void expireSessions(long timestamp) {
        HashSet<Long> sessions = new HashSet<Long>(this.executor.context().sessions().sessions.keySet());
        Iterator iterator = sessions.iterator();
        while (iterator.hasNext()) {
            long sessionId = (Long)iterator.next();
            ServerSession session = this.executor.context().sessions().getSession(sessionId);
            if (timestamp - session.timeout() <= session.getTimestamp()) continue;
            this.executor.context().sessions().unregisterSession(sessionId);
            session.expire();
            this.stateMachine.expire(session);
        }
    }

    @Override
    public void close() {
        this.executor.close();
    }

    private /* synthetic */ void lambda$apply$24(ServerSession serverSession, Context context, CompletableFuture completableFuture, long l) {
        this.stateMachine.register(serverSession);
        context.execute(() -> completableFuture.complete(l));
    }
}

