/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kuujo.catalog.client.session.Session;
import net.kuujo.catalog.server.session.Sessions;
import net.kuujo.catalog.server.state.ServerSession;
import net.kuujo.catalog.server.state.ServerStateMachineContext;
import net.kuujo.catalyst.transport.Connection;

class ServerSessionManager
implements Sessions {
    private final ServerStateMachineContext context;
    private final Map<UUID, Connection> connections = new ConcurrentHashMap<UUID, Connection>();
    final Map<Long, ServerSession> sessions = new ConcurrentHashMap<Long, ServerSession>();

    ServerSessionManager(ServerStateMachineContext context) {
        this.context = context;
    }

    @Override
    public Session session(long sessionId) {
        return this.sessions.get(sessionId);
    }

    ServerSessionManager registerConnection(Connection connection) {
        for (ServerSession session : this.sessions.values()) {
            if (!session.connection().equals(connection.id())) continue;
            session.setConnection(connection);
        }
        this.connections.put(connection.id(), connection);
        return this;
    }

    ServerSessionManager unregisterConnection(Connection connection) {
        for (ServerSession session : this.sessions.values()) {
            if (!session.connection().equals(connection.id())) continue;
            session.setConnection(null);
        }
        this.connections.remove(connection.id());
        return this;
    }

    ServerSession registerSession(long sessionId, UUID connectionId, long timeout) {
        ServerSession session = new ServerSession(sessionId, connectionId, this.context, timeout).setConnection(this.connections.get(connectionId));
        this.sessions.put(sessionId, session);
        return session;
    }

    ServerSession unregisterSession(long sessionId) {
        return this.sessions.remove(sessionId);
    }

    ServerSession getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public Iterator<Session> iterator() {
        return this.sessions.values().iterator();
    }
}

