/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.kuujo.catalog.client.request.CommandRequest;
import net.kuujo.catalog.client.request.KeepAliveRequest;
import net.kuujo.catalog.client.request.QueryRequest;
import net.kuujo.catalog.client.request.RegisterRequest;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.StateMachine;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.JoinRequest;
import net.kuujo.catalog.server.request.LeaveRequest;
import net.kuujo.catalog.server.request.PollRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.ClusterState;
import net.kuujo.catalog.server.state.ConnectionManager;
import net.kuujo.catalog.server.state.InactiveState;
import net.kuujo.catalog.server.state.JoinState;
import net.kuujo.catalog.server.state.LeaveState;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerStateMachine;
import net.kuujo.catalog.server.storage.Log;
import net.kuujo.catalog.server.storage.Storage;
import net.kuujo.catalyst.serializer.SerializableTypeResolver;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.ServiceLoaderTypeResolver;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Connection;
import net.kuujo.catalyst.transport.Server;
import net.kuujo.catalyst.transport.Transport;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.Listener;
import net.kuujo.catalyst.util.Listeners;
import net.kuujo.catalyst.util.Managed;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.Futures;
import net.kuujo.catalyst.util.concurrent.SingleThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContext
implements Managed<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerContext.class);
    private final Listeners<RaftServer.State> listeners = new Listeners();
    private final Serializer serializer;
    private Context context;
    private final StateMachine userStateMachine;
    private final Address address;
    private final Storage storage;
    private final ClusterState cluster;
    private final Map<Integer, Address> members;
    private final Transport transport;
    private Log log;
    private ServerStateMachine stateMachine;
    private Server server;
    private ConnectionManager connections;
    private AbstractState state = new InactiveState(this);
    private Duration electionTimeout = Duration.ofMillis(500L);
    private Duration sessionTimeout = Duration.ofMillis(5000L);
    private Duration heartbeatInterval = Duration.ofMillis(150L);
    private int leader;
    private long term;
    private int lastVotedFor;
    private long commitIndex;
    private long globalIndex;
    private volatile boolean open;
    private volatile CompletableFuture<Void> openFuture;

    public ServerContext(Address address, Collection<Address> members, Transport transport, Storage storage, StateMachine stateMachine, Serializer serializer) {
        this.address = (Address)Assert.notNull((Object)address, (String)"address");
        this.members = new HashMap<Integer, Address>();
        members.forEach(m -> this.members.put(m.hashCode(), (Address)m));
        this.members.put(address.hashCode(), address);
        this.transport = (Transport)Assert.notNull((Object)transport, (String)"transport");
        this.cluster = new ClusterState(this, address);
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
        storage.serializer().resolve(new SerializableTypeResolver[]{new ServiceLoaderTypeResolver()});
        serializer.resolve(new SerializableTypeResolver[]{new ServiceLoaderTypeResolver()});
        this.storage = (Storage)Assert.notNull((Object)storage, (String)"storage");
        this.userStateMachine = (StateMachine)Assert.notNull((Object)stateMachine, (String)"stateMachine");
    }

    public Listener<RaftServer.State> onStateChange(Consumer<RaftServer.State> listener) {
        return this.listeners.add(listener);
    }

    public Address getAddress() {
        return this.address;
    }

    public Serializer getSerializer() {
        return this.context.serializer();
    }

    public Context getContext() {
        return this.context;
    }

    ConnectionManager getConnections() {
        return this.connections;
    }

    public ServerContext setElectionTimeout(Duration electionTimeout) {
        this.electionTimeout = electionTimeout;
        return this;
    }

    public Duration getElectionTimeout() {
        return this.electionTimeout;
    }

    public ServerContext setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public ServerContext setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    ServerContext setLeader(int leader) {
        if (this.leader == 0) {
            if (leader != 0) {
                Address address = this.members.get(leader);
                if (address == null) {
                    throw new IllegalStateException("unknown leader: " + leader);
                }
                this.leader = leader;
                this.lastVotedFor = 0;
                LOGGER.debug("{} - Found leader {}", (Object)this.address, (Object)address);
                if (this.openFuture != null) {
                    this.openFuture.complete(null);
                    this.openFuture = null;
                }
            }
        } else if (leader != 0) {
            if (this.leader != leader) {
                Address address = this.members.get(leader);
                if (address == null) {
                    throw new IllegalStateException("unknown leader: " + leader);
                }
                this.leader = leader;
                this.lastVotedFor = 0;
                LOGGER.debug("{} - Found leader {}", (Object)this.address, (Object)address);
            }
        } else {
            this.leader = 0;
        }
        return this;
    }

    ClusterState getCluster() {
        return this.cluster;
    }

    public Address getLeader() {
        if (this.leader == 0) {
            return null;
        }
        if (this.leader == this.address.hashCode()) {
            return this.address;
        }
        MemberState member = this.cluster.getMember(this.leader);
        return member != null ? member.getAddress() : null;
    }

    ServerContext setTerm(long term) {
        if (term > this.term) {
            this.term = term;
            this.leader = 0;
            this.lastVotedFor = 0;
            LOGGER.debug("{} - Incremented term {}", (Object)this.address, (Object)term);
        }
        return this;
    }

    public long getTerm() {
        return this.term;
    }

    ServerContext setLastVotedFor(int candidate) {
        if (this.lastVotedFor != 0 && candidate != 0) {
            throw new IllegalStateException("Already voted for another candidate");
        }
        if (this.leader != 0 && candidate != 0) {
            throw new IllegalStateException("Cannot cast vote - leader already exists");
        }
        Address address = this.members.get(candidate);
        if (address == null) {
            throw new IllegalStateException("unknown candidate: " + candidate);
        }
        this.lastVotedFor = candidate;
        if (candidate != 0) {
            LOGGER.debug("{} - Voted for {}", (Object)this.address, (Object)address);
        } else {
            LOGGER.debug("{} - Reset last voted for", (Object)this.address);
        }
        return this;
    }

    public int getLastVotedFor() {
        return this.lastVotedFor;
    }

    ServerContext setCommitIndex(long commitIndex) {
        if (commitIndex < 0L) {
            throw new IllegalArgumentException("commit index must be positive");
        }
        if (commitIndex < this.commitIndex) {
            throw new IllegalArgumentException("cannot decrease commit index");
        }
        this.commitIndex = commitIndex;
        return this;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    ServerContext setGlobalIndex(long globalIndex) {
        if (globalIndex < 0L) {
            throw new IllegalArgumentException("global index must be positive");
        }
        this.globalIndex = Math.max(this.globalIndex, globalIndex);
        this.log.commit(this.globalIndex);
        return this;
    }

    public long getGlobalIndex() {
        return this.globalIndex;
    }

    ServerStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public long getLastApplied() {
        return this.stateMachine.getLastApplied();
    }

    public RaftServer.State getState() {
        return this.state.type();
    }

    public Log getLog() {
        return this.log;
    }

    void checkThread() {
        this.context.checkThread();
    }

    CompletableFuture<RaftServer.State> transition(Class<? extends AbstractState> state) {
        this.checkThread();
        if (this.state != null && state == this.state.getClass()) {
            return CompletableFuture.completedFuture(this.state.type());
        }
        LOGGER.info("{} - Transitioning to {}", (Object)this.address, (Object)state.getSimpleName());
        if (this.state != null) {
            try {
                this.state.close().get();
                this.state = state.getConstructor(ServerContext.class).newInstance(this);
                this.state.open().get();
            }
            catch (IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException | ExecutionException e) {
                throw new IllegalStateException("failed to initialize Raft state", e);
            }
        }
        try {
            this.state = state.getConstructor(ServerContext.class).newInstance(this);
            this.state.open().get();
        }
        catch (IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize Raft state", e);
        }
        this.listeners.forEach(l -> l.accept((Object)this.state.type()));
        return CompletableFuture.completedFuture(null);
    }

    private void handleConnect(Connection connection) {
        this.stateMachine.executor().context().sessions().registerConnection(connection);
        this.registerHandlers(connection);
        connection.closeListener(this.stateMachine.executor().context().sessions()::unregisterConnection);
    }

    private void registerHandlers(Connection connection) {
        this.context.checkThread();
        connection.handler(RegisterRequest.class, request -> this.state.register((RegisterRequest)request));
        connection.handler(KeepAliveRequest.class, request -> this.state.keepAlive((KeepAliveRequest)request));
        connection.handler(JoinRequest.class, request -> this.state.join((JoinRequest)((Object)request)));
        connection.handler(LeaveRequest.class, request -> this.state.leave((LeaveRequest)((Object)request)));
        connection.handler(AppendRequest.class, request -> this.state.append((AppendRequest)((Object)request)));
        connection.handler(PollRequest.class, request -> this.state.poll((PollRequest)((Object)request)));
        connection.handler(VoteRequest.class, request -> this.state.vote((VoteRequest)((Object)request)));
        connection.handler(CommandRequest.class, request -> this.state.command((CommandRequest)request));
        connection.handler(QueryRequest.class, request -> this.state.query((QueryRequest)request));
    }

    public synchronized CompletableFuture<Void> open() {
        if (this.open) {
            return CompletableFuture.completedFuture(null);
        }
        this.context = new SingleThreadContext("catalog-server-" + this.address, this.serializer);
        this.openFuture = new CompletableFuture();
        this.context.executor().execute(() -> {
            this.log = this.storage.open("catalog");
            this.cluster.configure(0L, this.members.values(), Collections.EMPTY_LIST);
            SingleThreadContext stateContext = new SingleThreadContext("catalog-server-" + this.address + "-state-%d", this.serializer.clone());
            this.stateMachine = new ServerStateMachine(this.userStateMachine, arg_0 -> ((Log)this.log).clean(arg_0), (Context)stateContext);
            UUID id = UUID.randomUUID();
            this.server = this.transport.server(id);
            this.connections = new ConnectionManager(this.transport.client(id));
            this.server.listen(this.address, this::handleConnect).thenRun(() -> {
                this.transition(JoinState.class);
                this.open = true;
            });
        });
        return this.openFuture.thenRun(() -> LOGGER.info("{} - Started successfully!", (Object)this.address));
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized CompletableFuture<Void> close() {
        if (!this.open) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("context not open"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.executor().execute(() -> {
            this.open = false;
            this.onStateChange(state -> {
                if (state == RaftServer.State.INACTIVE) {
                    this.server.close().whenCompleteAsync((r1, e1) -> {
                        try {
                            this.log.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.stateMachine.close();
                        this.context.close();
                        if (e1 != null) {
                            future.completeExceptionally((Throwable)e1);
                        } else {
                            future.complete(null);
                        }
                    }, this.context.executor());
                }
            });
            this.transition(LeaveState.class);
        });
        return future;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public CompletableFuture<Void> delete() {
        if (this.open) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("cannot delete open context"));
        }
        return CompletableFuture.runAsync(() -> ((Log)this.log).delete(), this.context.executor());
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }
}

