/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kuujo.catalog.server.state.ServerCommit;
import net.kuujo.catalog.server.state.ServerCommitCleaner;
import net.kuujo.catalog.server.state.ServerSessionManager;
import net.kuujo.catalog.server.storage.OperationEntry;

class ServerCommitPool
implements AutoCloseable {
    private final ServerCommitCleaner cleaner;
    private final ServerSessionManager sessions;
    private final Queue<ServerCommit> pool = new ConcurrentLinkedQueue<ServerCommit>();

    public ServerCommitPool(ServerCommitCleaner cleaner, ServerSessionManager sessions) {
        this.cleaner = cleaner;
        this.sessions = sessions;
    }

    public ServerCommit acquire(OperationEntry entry) {
        ServerCommit commit = this.pool.poll();
        if (commit == null) {
            commit = new ServerCommit(this, this.cleaner, this.sessions);
        }
        commit.reset(entry);
        return commit;
    }

    public void release(ServerCommit commit) {
        this.pool.add(commit);
    }

    @Override
    public void close() {
        this.pool.clear();
    }
}

