/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.time.Instant;
import net.kuujo.catalog.client.Operation;
import net.kuujo.catalog.client.session.Session;
import net.kuujo.catalog.server.Commit;
import net.kuujo.catalog.server.state.ServerCommitCleaner;
import net.kuujo.catalog.server.state.ServerCommitPool;
import net.kuujo.catalog.server.state.ServerSessionManager;
import net.kuujo.catalog.server.storage.OperationEntry;

class ServerCommit
implements Commit<Operation> {
    private final ServerCommitPool pool;
    private final ServerCommitCleaner cleaner;
    private final ServerSessionManager sessions;
    private long index;
    private Session session;
    private Instant instant;
    private Operation operation;
    private volatile boolean open;

    public ServerCommit(ServerCommitPool pool, ServerCommitCleaner cleaner, ServerSessionManager sessions) {
        this.pool = pool;
        this.cleaner = cleaner;
        this.sessions = sessions;
    }

    void reset(OperationEntry entry) {
        this.index = entry.getIndex();
        this.session = this.sessions.getSession(entry.getSession());
        this.instant = Instant.ofEpochMilli(entry.getTimestamp());
        this.operation = entry.getOperation();
        this.open = true;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public Instant time() {
        return this.instant;
    }

    @Override
    public Class type() {
        return this.operation.getClass();
    }

    @Override
    public Operation operation() {
        return this.operation;
    }

    @Override
    public void clean() {
        if (!this.open) {
            throw new IllegalStateException("commit closed");
        }
        this.cleaner.clean(this.index);
        this.close();
    }

    @Override
    public void close() {
        if (this.open) {
            this.pool.release(this);
            this.open = false;
        }
    }

    public String toString() {
        return String.format("%s[index=%d, session=%s, time=%s, operation=%s]", this.getClass().getSimpleName(), this.index(), this.session(), this.time(), this.operation());
    }
}

