/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.request.CommandRequest;
import net.kuujo.catalog.client.request.KeepAliveRequest;
import net.kuujo.catalog.client.request.QueryRequest;
import net.kuujo.catalog.client.request.RegisterRequest;
import net.kuujo.catalog.client.request.Request;
import net.kuujo.catalog.client.response.AbstractResponse;
import net.kuujo.catalog.client.response.CommandResponse;
import net.kuujo.catalog.client.response.KeepAliveResponse;
import net.kuujo.catalog.client.response.QueryResponse;
import net.kuujo.catalog.client.response.RegisterResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.JoinRequest;
import net.kuujo.catalog.server.request.LeaveRequest;
import net.kuujo.catalog.server.request.PollRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.response.AppendResponse;
import net.kuujo.catalog.server.response.JoinResponse;
import net.kuujo.catalog.server.response.LeaveResponse;
import net.kuujo.catalog.server.response.PollResponse;
import net.kuujo.catalog.server.response.VoteResponse;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalog.server.storage.ConfigurationEntry;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.RaftEntry;

class PassiveState
extends AbstractState {
    private final Queue<AtomicInteger> counterPool = new ArrayDeque<AtomicInteger>();

    public PassiveState(ServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.State type() {
        return RaftServer.State.PASSIVE;
    }

    @Override
    protected CompletableFuture<AppendResponse> append(AppendRequest request) {
        try {
            this.context.checkThread();
            if (request.term() > this.context.getTerm() || request.term() == this.context.getTerm() && this.context.getLeader() == null) {
                this.context.setTerm(request.term());
                this.context.setLeader(request.leader());
            }
            CompletableFuture<AppendResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(this.handleAppend(this.logRequest(request))));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    protected AppendResponse handleAppend(AppendRequest request) {
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.warn("{} - Rejected {}: request term is less than the current term ({})", new Object[]{this.context.getAddress(), request, this.context.getTerm()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        if (request.logIndex() != 0L && request.logTerm() != 0L) {
            return this.doCheckPreviousEntry(request);
        }
        return this.doAppendEntries(request);
    }

    protected AppendResponse doCheckPreviousEntry(AppendRequest request) {
        if (request.logIndex() != 0L && this.context.getLog().isEmpty()) {
            this.LOGGER.warn("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getAddress(), request, request.logIndex(), this.context.getLog().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        if (request.logIndex() != 0L && this.context.getLog().lastIndex() != 0L && request.logIndex() > this.context.getLog().lastIndex()) {
            this.LOGGER.warn("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getAddress(), request, request.logIndex(), this.context.getLog().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        try (RaftEntry entry = (RaftEntry)this.context.getLog().get(request.logIndex());){
            if (entry == null || entry.getTerm() != request.logTerm()) {
                this.LOGGER.warn("{} - Rejected {}: Request log term does not match local log term {} for the same entry", new Object[]{this.context.getAddress(), request, entry != null ? Long.valueOf(entry.getTerm()) : "unknown"});
                AppendResponse appendResponse = ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(request.logIndex() <= this.context.getLog().lastIndex() ? request.logIndex() - 1L : this.context.getLog().lastIndex()).build();
                return appendResponse;
            }
            AppendResponse appendResponse = this.doAppendEntries(request);
            return appendResponse;
        }
    }

    protected AppendResponse doAppendEntries(AppendRequest request) {
        if (!request.entries().isEmpty()) {
            for (RaftEntry raftEntry : request.entries()) {
                if (this.context.getLog().lastIndex() < raftEntry.getIndex()) {
                    this.context.getLog().skip(raftEntry.getIndex() - this.context.getLog().lastIndex() - 1L).append((Entry)raftEntry);
                    this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getAddress(), raftEntry, raftEntry.getIndex()});
                } else {
                    try (RaftEntry match = (RaftEntry)this.context.getLog().get(raftEntry.getIndex());){
                        if (match != null) {
                            if (raftEntry.getTerm() != match.getTerm()) {
                                this.LOGGER.warn("{} - Appended entry term does not match local log, removing incorrect entries", (Object)this.context.getAddress());
                                this.context.getLog().truncate(raftEntry.getIndex() - 1L);
                                this.context.getLog().append((Entry)raftEntry);
                                this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getAddress(), raftEntry, raftEntry.getIndex()});
                            }
                        } else {
                            this.context.getLog().truncate(raftEntry.getIndex() - 1L).append((Entry)raftEntry);
                            this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getAddress(), raftEntry, raftEntry.getIndex()});
                        }
                    }
                }
                if (!(raftEntry instanceof ConfigurationEntry)) continue;
                ConfigurationEntry configurationEntry = (ConfigurationEntry)raftEntry;
                if (this.context.getCluster().isPassive()) {
                    this.context.getCluster().configure(raftEntry.getIndex(), configurationEntry.getActive(), configurationEntry.getPassive());
                    if (!this.context.getCluster().isActive()) continue;
                    this.transition(RaftServer.State.FOLLOWER);
                    continue;
                }
                this.context.getCluster().configure(raftEntry.getIndex(), configurationEntry.getActive(), configurationEntry.getPassive());
                if (!this.context.getCluster().isPassive()) continue;
                this.transition(RaftServer.State.PASSIVE);
            }
        }
        this.context.getContext().execute(() -> this.applyCommits(request.commitIndex())).thenRun(() -> this.applyIndex(request.globalIndex()));
        return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(true).withLogIndex(this.context.getLog().lastIndex()).build();
    }

    protected CompletableFuture<Void> applyCommits(long commitIndex) {
        this.context.setCommitIndex(Math.max(this.context.getCommitIndex(), commitIndex));
        long lastIndex = this.context.getLog().lastIndex();
        long lastApplied = this.context.getLastApplied();
        long effectiveIndex = Math.min(lastIndex, this.context.getCommitIndex());
        if (effectiveIndex > lastApplied) {
            long entriesToApply = effectiveIndex - lastApplied;
            this.LOGGER.debug("{} - Applying {} commits", (Object)this.context.getAddress(), (Object)entriesToApply);
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            AtomicInteger counter = this.getCounter();
            for (long i = lastApplied + 1L; i <= effectiveIndex; ++i) {
                Entry entry = this.context.getLog().get(i);
                if (entry == null || entry instanceof ConfigurationEntry) continue;
                this.applyEntry(entry).whenComplete((result, error) -> {
                    if (this.isOpen() && error != null) {
                        this.LOGGER.info("{} - An application error occurred: {}", (Object)this.context.getAddress(), (Object)error.getMessage());
                    }
                    if ((long)counter.incrementAndGet() == entriesToApply) {
                        future.complete(null);
                        this.recycleCounter(counter);
                    }
                    entry.release();
                });
            }
            return future;
        }
        return CompletableFuture.completedFuture(null);
    }

    private AtomicInteger getCounter() {
        AtomicInteger counter = this.counterPool.poll();
        if (counter == null) {
            counter = new AtomicInteger();
        }
        counter.set(0);
        return counter;
    }

    private void recycleCounter(AtomicInteger counter) {
        this.counterPool.add(counter);
    }

    protected CompletableFuture<?> applyEntry(Entry entry) {
        this.LOGGER.debug("{} - Applying {}", (Object)this.context.getAddress(), (Object)entry);
        return this.context.getStateMachine().apply(entry);
    }

    protected void applyIndex(long globalIndex) {
        if (globalIndex > 0L) {
            this.context.setGlobalIndex(globalIndex);
        }
    }

    @Override
    protected CompletableFuture<PollResponse> poll(PollRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            CompletableFuture<PollResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<VoteResponse> vote(VoteRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            CompletableFuture<VoteResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    protected <T extends Request<T>, U extends Response<U>> CompletableFuture<U> forward(T request) {
        request.acquire();
        CompletableFuture future = new CompletableFuture();
        this.context.getConnections().getConnection(this.context.getLeader()).whenComplete((connection, connectError) -> {
            if (connectError == null) {
                connection.send((Object)request).whenComplete((response, responseError) -> {
                    if (responseError == null) {
                        future.complete(response);
                    } else {
                        future.completeExceptionally((Throwable)responseError);
                    }
                });
            } else {
                request.release();
            }
        });
        return future;
    }

    @Override
    protected CompletableFuture<CommandResponse> command(CommandRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<AbstractResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.NO_LEADER_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<QueryResponse> query(QueryRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<AbstractResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.NO_LEADER_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<RegisterResponse> register(RegisterRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            CompletableFuture<RegisterResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            CompletableFuture<KeepAliveResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<JoinResponse> join(JoinRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<JoinResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<AbstractResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }
}

