/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.LeaveRequest;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.InactiveState;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.util.concurrent.Scheduled;

final class LeaveState
extends InactiveState {
    private Scheduled leaveFuture;

    public LeaveState(ServerContext context) {
        super(context);
    }

    @Override
    public CompletableFuture<AbstractState> open() {
        return ((CompletableFuture)((CompletableFuture)super.open().thenRun(this::startLeaveTimeout)).thenRun(this::leave)).thenApply(v -> this);
    }

    @Override
    public RaftServer.State type() {
        return RaftServer.State.LEAVE;
    }

    private void startLeaveTimeout() {
        this.leaveFuture = this.context.getContext().schedule(() -> {
            if (this.isOpen()) {
                this.LOGGER.warn("{} - Failed to leave the cluster in {} milliseconds", (Object)this.context.getAddress(), (Object)this.context.getElectionTimeout());
                this.transition(RaftServer.State.INACTIVE);
            }
        }, this.context.getElectionTimeout());
    }

    private void leave() {
        if (this.context.getLeader() == null) {
            this.leave(this.context.getLeader(), this.context.getCluster().getActiveMembers().iterator());
        } else {
            Iterator<MemberState> iterator = this.context.getCluster().getActiveMembers().iterator();
            if (iterator.hasNext()) {
                this.leave(iterator.next().getAddress(), iterator);
            } else {
                this.LOGGER.debug("{} - Failed to leave the cluster", (Object)this.context.getAddress());
                this.transition(RaftServer.State.INACTIVE);
            }
        }
    }

    private void leave(Address member, Iterator<MemberState> iterator) {
        this.LOGGER.debug("{} - Attempting to leave via {}", (Object)this.context.getAddress(), (Object)member);
        this.context.getConnections().getConnection(member).thenAccept(connection -> {
            if (this.isOpen()) {
                LeaveRequest request = LeaveRequest.builder().withMember(this.context.getAddress()).build();
                connection.send((Object)request).whenComplete((response, error) -> {
                    if (this.isOpen()) {
                        if (error == null) {
                            if (response.status() == Response.Status.OK) {
                                this.LOGGER.info("{} - Successfully left via {}", (Object)this.context.getAddress(), (Object)member);
                                this.transition(RaftServer.State.INACTIVE);
                            } else {
                                this.LOGGER.debug("{} - Failed to leave {}", (Object)this.context.getAddress(), (Object)member);
                                if (iterator.hasNext()) {
                                    this.leave(((MemberState)iterator.next()).getAddress(), iterator);
                                } else {
                                    this.transition(RaftServer.State.INACTIVE);
                                }
                            }
                        } else {
                            this.LOGGER.debug("{} - Failed to leave {}", (Object)this.context.getAddress(), (Object)member);
                            if (iterator.hasNext()) {
                                this.leave(((MemberState)iterator.next()).getAddress(), iterator);
                            } else {
                                this.transition(RaftServer.State.INACTIVE);
                            }
                        }
                    }
                });
            }
        });
    }

    private void cancelLeaveTimer() {
        if (this.leaveFuture != null) {
            this.LOGGER.info("{} - Cancelling leave timeout", (Object)this.context.getAddress());
            this.leaveFuture.cancel();
            this.leaveFuture = null;
        }
    }

    @Override
    public CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelLeaveTimer);
    }
}

