/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.kuujo.catalog.client.Command;
import net.kuujo.catalog.client.ConsistencyLevel;
import net.kuujo.catalog.client.Query;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.error.RaftException;
import net.kuujo.catalog.client.request.CommandRequest;
import net.kuujo.catalog.client.request.KeepAliveRequest;
import net.kuujo.catalog.client.request.QueryRequest;
import net.kuujo.catalog.client.request.RegisterRequest;
import net.kuujo.catalog.client.response.AbstractResponse;
import net.kuujo.catalog.client.response.CommandResponse;
import net.kuujo.catalog.client.response.KeepAliveResponse;
import net.kuujo.catalog.client.response.QueryResponse;
import net.kuujo.catalog.client.response.RegisterResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.JoinRequest;
import net.kuujo.catalog.server.request.LeaveRequest;
import net.kuujo.catalog.server.request.PollRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.response.AppendResponse;
import net.kuujo.catalog.server.response.JoinResponse;
import net.kuujo.catalog.server.response.LeaveResponse;
import net.kuujo.catalog.server.response.PollResponse;
import net.kuujo.catalog.server.response.VoteResponse;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.ActiveState;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalog.server.storage.CommandEntry;
import net.kuujo.catalog.server.storage.ConfigurationEntry;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.KeepAliveEntry;
import net.kuujo.catalog.server.storage.NoOpEntry;
import net.kuujo.catalog.server.storage.QueryEntry;
import net.kuujo.catalog.server.storage.RaftEntry;
import net.kuujo.catalog.server.storage.RegisterEntry;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.util.concurrent.Scheduled;

final class LeaderState
extends ActiveState {
    private static final int MAX_BATCH_SIZE = 28672;
    private Scheduled currentTimer;
    private final Replicator replicator = new Replicator();

    public LeaderState(ServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.State type() {
        return RaftServer.State.LEADER;
    }

    @Override
    public synchronized CompletableFuture<AbstractState> open() {
        this.context.getContext().execute(this::commitEntries).whenComplete((result, error) -> {
            if (this.isOpen() && error == null) {
                this.startHeartbeatTimer();
            }
        });
        return ((CompletableFuture)super.open().thenRun(this::takeLeadership)).thenApply(v -> this);
    }

    private void takeLeadership() {
        this.context.setLeader(this.context.getAddress().hashCode());
    }

    private CompletableFuture<Void> commitEntries() {
        long index;
        long term = this.context.getTerm();
        try (NoOpEntry entry = (NoOpEntry)this.context.getLog().create(NoOpEntry.class);){
            ((NoOpEntry)((Object)entry.setTerm(term))).setTimestamp(System.currentTimeMillis());
            index = this.context.getLog().append((Entry)entry);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.replicator.commit(index).whenComplete((resultIndex, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    this.applyEntries((long)resultIndex);
                    future.complete(null);
                } else {
                    this.transition(RaftServer.State.FOLLOWER);
                }
            }
        });
        return future;
    }

    private void applyEntries(long index) {
        if (!this.context.getLog().isEmpty()) {
            int count = 0;
            for (long lastApplied = Math.max(this.context.getLastApplied(), this.context.getLog().firstIndex()); lastApplied <= index; ++lastApplied) {
                Entry entry = this.context.getLog().get(lastApplied);
                if (entry != null) {
                    this.context.getStateMachine().apply(entry).whenComplete((result, error) -> {
                        if (this.isOpen() && error != null) {
                            this.LOGGER.info("{} - An application error occurred: {}", (Object)this.context.getAddress(), (Object)error.getMessage());
                        }
                        entry.release();
                    });
                }
                ++count;
            }
            this.LOGGER.debug("{} - Applied {} entries to log", (Object)this.context.getAddress(), (Object)count);
        }
    }

    private void startHeartbeatTimer() {
        this.LOGGER.debug("{} - Starting heartbeat timer", (Object)this.context.getAddress());
        this.currentTimer = this.context.getContext().schedule(this::heartbeatMembers, Duration.ZERO, this.context.getHeartbeatInterval());
    }

    private void heartbeatMembers() {
        this.context.checkThread();
        if (this.isOpen()) {
            this.replicator.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<JoinResponse> join(JoinRequest request) {
        try {
            long index;
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getCluster().getMember(request.member().hashCode()) != null) {
                CompletableFuture<JoinResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.OK)).withVersion(this.context.getCluster().getVersion()).withActiveMembers(this.context.getCluster().buildActiveMembers()).withPassiveMembers(this.context.getCluster().buildPassiveMembers()).build()));
                return completableFuture;
            }
            long term = this.context.getTerm();
            Collection<Address> activeMembers = this.context.getCluster().buildActiveMembers();
            Collection<Address> passiveMembers = this.context.getCluster().buildPassiveMembers();
            passiveMembers.add(request.member());
            ConfigurationEntry entry = (ConfigurationEntry)this.context.getLog().create(ConfigurationEntry.class);
            Object object = null;
            try {
                ((ConfigurationEntry)((Object)entry.setTerm(term))).setActive(activeMembers).setPassive(passiveMembers);
                index = this.context.getLog().append((Entry)entry);
                this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getAddress(), entry, index});
                this.context.getCluster().configure(entry.getIndex(), entry.getActive(), entry.getPassive());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (entry != null) {
                    if (object != null) {
                        try {
                            entry.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        entry.close();
                    }
                }
            }
            CompletableFuture future = new CompletableFuture();
            this.replicator.commit(index).whenComplete((commitIndex, commitError) -> {
                this.context.checkThread();
                if (this.isOpen()) {
                    if (commitError == null) {
                        future.complete(this.logResponse(((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.OK)).withVersion(index).withActiveMembers(activeMembers).withPassiveMembers(passiveMembers).build()));
                    } else {
                        future.complete(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                    }
                }
            });
            object = future;
            return object;
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        try {
            long index;
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getCluster().getMember(request.member().hashCode()) == null) {
                CompletableFuture<AbstractResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.OK)).build()));
                return completableFuture;
            }
            long term = this.context.getTerm();
            Collection<Address> activeMembers = this.context.getCluster().buildActiveMembers();
            activeMembers.remove(request.member());
            Collection<Address> passiveMembers = this.context.getCluster().buildPassiveMembers();
            passiveMembers.remove(request.member());
            ConfigurationEntry entry = (ConfigurationEntry)this.context.getLog().create(ConfigurationEntry.class);
            Object object = null;
            try {
                ((ConfigurationEntry)((Object)entry.setTerm(term))).setActive(activeMembers).setPassive(passiveMembers);
                index = this.context.getLog().append((Entry)entry);
                this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getAddress(), entry, index});
                this.context.getCluster().configure(entry.getIndex(), entry.getActive(), entry.getPassive());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (entry != null) {
                    if (object != null) {
                        try {
                            entry.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        entry.close();
                    }
                }
            }
            CompletableFuture future = new CompletableFuture();
            this.replicator.commit(index).whenComplete((commitIndex, commitError) -> {
                this.context.checkThread();
                if (this.isOpen()) {
                    if (commitError == null) {
                        future.complete(this.logResponse(((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.OK)).build()));
                    } else {
                        future.complete(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                    }
                }
            });
            object = future;
            return object;
        }
        finally {
            request.release();
        }
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        try {
            CompletableFuture<PollResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build()));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        try {
            if (request.term() > this.context.getTerm()) {
                this.LOGGER.debug("{} - Received greater term", (Object)this.context.getAddress());
                this.context.setLeader(0);
                this.transition(RaftServer.State.FOLLOWER);
                request.acquire();
                CompletableFuture<VoteResponse> completableFuture = super.vote(request);
                return completableFuture;
            }
            CompletableFuture<VoteResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build()));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        try {
            this.context.checkThread();
            if (request.term() > this.context.getTerm()) {
                request.acquire();
                CompletableFuture<AppendResponse> completableFuture = super.append(request);
                return completableFuture;
            }
            if (request.term() < this.context.getTerm()) {
                CompletableFuture<AppendResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build()));
                return completableFuture;
            }
            this.context.setLeader(request.leader());
            this.transition(RaftServer.State.FOLLOWER);
            request.acquire();
            CompletableFuture<AppendResponse> completableFuture = super.append(request);
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<CommandResponse> command(CommandRequest request) {
        long index;
        CompletableFuture<CommandResponse> future = new CompletableFuture<CommandResponse>();
        Command command = request.command();
        long term = this.context.getTerm();
        long timestamp = System.currentTimeMillis();
        try {
            this.context.checkThread();
            this.logRequest(request);
            try (CommandEntry entry = (CommandEntry)this.context.getLog().create(CommandEntry.class);){
                ((CommandEntry)((Object)((CommandEntry)((Object)((CommandEntry)((Object)entry.setTerm(term))).setTimestamp(timestamp))).setSession(request.session()))).setSequence(request.sequence()).setCommand(command);
                index = this.context.getLog().append((Entry)entry);
                this.LOGGER.debug("{} - Appended entry to log at index {}", (Object)this.context.getAddress(), (Object)index);
            }
        }
        finally {
            request.release();
        }
        this.replicator.commit(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    CommandEntry entry = (CommandEntry)this.context.getLog().get(index);
                    this.applyEntry(entry).whenComplete((result, error) -> {
                        if (this.isOpen()) {
                            if (error == null) {
                                future.complete((CommandResponse)this.logResponse(((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.OK)).withVersion(index).withResult(result).build()));
                            } else if (error instanceof RaftException) {
                                future.complete((CommandResponse)this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withVersion(index).withError((RaftError)((RaftException)error).getType())).build()));
                            } else {
                                future.complete((CommandResponse)this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                            }
                        }
                        entry.release();
                    });
                } else {
                    future.complete((CommandResponse)this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    protected CompletableFuture<QueryResponse> query(QueryRequest request) {
        Query query = request.query();
        long timestamp = System.currentTimeMillis();
        long index = this.context.getCommitIndex();
        try {
            this.context.checkThread();
            this.logRequest(request);
            QueryEntry entry = ((QueryEntry)((Object)((QueryEntry)((Object)((QueryEntry)((Object)((QueryEntry)((QueryEntry)this.context.getLog().create(QueryEntry.class)).setIndex(index)).setTerm(this.context.getTerm()))).setTimestamp(timestamp))).setSession(request.session()))).setVersion(request.version()).setQuery(query);
            ConsistencyLevel consistency = query.consistency();
            if (consistency == null) {
                CompletableFuture<QueryResponse> completableFuture = this.submitQueryLinearizableStrict(entry);
                return completableFuture;
            }
            switch (consistency) {
                case SERIALIZABLE: {
                    CompletableFuture<QueryResponse> completableFuture = this.submitQuerySerializable(entry);
                    return completableFuture;
                }
                case LINEARIZABLE_LEASE: {
                    CompletableFuture<QueryResponse> completableFuture = this.submitQueryLinearizableLease(entry);
                    return completableFuture;
                }
                case LINEARIZABLE: {
                    CompletableFuture<QueryResponse> completableFuture = this.submitQueryLinearizableStrict(entry);
                    return completableFuture;
                }
            }
            throw new IllegalStateException("unknown consistency level");
        }
        finally {
            request.release();
        }
    }

    private CompletableFuture<QueryResponse> submitQuerySerializable(QueryEntry entry) {
        return this.applyQuery(entry, new CompletableFuture<QueryResponse>());
    }

    private CompletableFuture<QueryResponse> submitQueryLinearizableLease(QueryEntry entry) {
        long commitTime = this.replicator.commitTime();
        if (System.currentTimeMillis() - commitTime < this.context.getElectionTimeout().toMillis()) {
            return this.submitQuerySerializable(entry);
        }
        return this.submitQueryLinearizableStrict(entry);
    }

    private CompletableFuture<QueryResponse> submitQueryLinearizableStrict(QueryEntry entry) {
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        this.replicator.commit().whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    entry.acquire();
                    this.applyQuery(entry, future);
                } else {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.COMMAND_ERROR)).build()));
                }
            }
            entry.release();
        });
        return future;
    }

    private CompletableFuture<QueryResponse> applyQuery(QueryEntry entry, CompletableFuture<QueryResponse> future) {
        long version = this.context.getLastApplied();
        this.applyEntry(entry).whenComplete((result, error) -> {
            if (this.isOpen()) {
                if (error == null) {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.OK)).withVersion(version).withResult(result).build()));
                } else if (error instanceof RaftException) {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withVersion(version).withError((RaftError)((RaftException)error).getType())).build()));
                } else {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                }
            }
            entry.release();
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<RegisterResponse> register(RegisterRequest request) {
        long index;
        long timestamp = System.currentTimeMillis();
        long timeout = this.context.getSessionTimeout().toMillis();
        try {
            this.context.checkThread();
            this.logRequest(request);
            try (RegisterEntry entry = (RegisterEntry)this.context.getLog().create(RegisterEntry.class);){
                entry.setTerm(this.context.getTerm());
                entry.setTimestamp(timestamp);
                entry.setConnection(request.connection());
                entry.setTimeout(timeout);
                index = this.context.getLog().append((Entry)entry);
                this.LOGGER.debug("{} - Appended {}", (Object)this.context.getAddress(), (Object)entry);
            }
        }
        finally {
            request.release();
        }
        CompletableFuture<RegisterResponse> future = new CompletableFuture<RegisterResponse>();
        this.replicator.commit(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    RegisterEntry entry = (RegisterEntry)this.context.getLog().get(index);
                    this.applyEntry(entry).whenComplete((sessionId, sessionError) -> {
                        if (this.isOpen()) {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.OK)).withSession(((Long)sessionId).longValue()).withTimeout(timeout).withMembers(this.context.getCluster().buildActiveMembers()).build()));
                            } else if (sessionError instanceof RaftException) {
                                future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)((RaftException)sessionError).getType())).build()));
                            } else {
                                future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                            }
                        }
                        entry.release();
                    });
                } else {
                    future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        long index;
        long timestamp = System.currentTimeMillis();
        try {
            this.context.checkThread();
            this.logRequest(request);
            try (KeepAliveEntry entry = (KeepAliveEntry)this.context.getLog().create(KeepAliveEntry.class);){
                ((KeepAliveEntry)((Object)((KeepAliveEntry)((Object)entry.setTerm(this.context.getTerm()))).setSession(request.session()))).setCommandSequence(request.commandSequence()).setEventVersion(request.eventVersion()).setEventSequence(request.eventSequence()).setTimestamp(timestamp);
                index = this.context.getLog().append((Entry)entry);
                this.LOGGER.debug("{} - Appended {}", (Object)this.context.getAddress(), (Object)entry);
            }
        }
        finally {
            request.release();
        }
        CompletableFuture<KeepAliveResponse> future = new CompletableFuture<KeepAliveResponse>();
        this.replicator.commit(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    KeepAliveEntry entry = (KeepAliveEntry)this.context.getLog().get(index);
                    this.applyEntry(entry).whenCompleteAsync((sessionResult, sessionError) -> {
                        if (this.isOpen()) {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.OK)).withMembers(this.context.getCluster().buildActiveMembers()).build()));
                            } else if (sessionError instanceof RaftException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)((RaftException)sessionError).getType())).build()));
                            } else {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                            }
                        }
                        entry.release();
                    }, this.context.getContext().executor());
                } else {
                    future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    private void cancelPingTimer() {
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Cancelling heartbeat timer", (Object)this.context.getAddress());
            this.currentTimer.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelPingTimer);
    }

    private class Replicator {
        private final Set<MemberState> committing = new HashSet<MemberState>();
        private long commitTime;
        private CompletableFuture<Long> commitFuture;
        private CompletableFuture<Long> nextCommitFuture;
        private final TreeMap<Long, CompletableFuture<Long>> commitFutures = new TreeMap();

        private Replicator() {
        }

        private int quorumIndex() {
            return LeaderState.this.context.getCluster().getQuorum() - 1;
        }

        private CompletableFuture<Long> commit() {
            if (LeaderState.this.context.getCluster().getMembers().size() == 1) {
                return CompletableFuture.completedFuture(null);
            }
            if (this.commitFuture == null) {
                this.commitFuture = new CompletableFuture();
                this.commitTime = System.currentTimeMillis();
                for (MemberState member : LeaderState.this.context.getCluster().getMembers()) {
                    this.commit(member);
                }
                return this.commitFuture;
            }
            if (this.nextCommitFuture == null) {
                this.nextCommitFuture = new CompletableFuture();
                return this.nextCommitFuture;
            }
            return this.nextCommitFuture;
        }

        private CompletableFuture<Long> commit(long index) {
            if (index == 0L) {
                return this.commit();
            }
            if (LeaderState.this.context.getCluster().getActiveMembers().isEmpty()) {
                LeaderState.this.context.setCommitIndex(index);
                return CompletableFuture.completedFuture(index);
            }
            return this.commitFutures.computeIfAbsent(index, i -> {
                for (MemberState member : LeaderState.this.context.getCluster().getMembers()) {
                    this.commit(member);
                }
                return new CompletableFuture();
            });
        }

        private long commitTime() {
            return LeaderState.this.context.getCluster().getActiveMembers((m1, m2) -> (int)(m2.getTime() - m1.getTime())).get(this.quorumIndex()).getTime();
        }

        private void commitTime(MemberState member) {
            member.setTime(System.currentTimeMillis());
            long commitTime = this.commitTime();
            if (this.commitFuture != null && this.commitTime <= commitTime) {
                this.commitFuture.complete(null);
                this.commitFuture = this.nextCommitFuture;
                this.nextCommitFuture = null;
                if (this.commitFuture != null) {
                    this.commitTime = System.currentTimeMillis();
                    for (MemberState replica : LeaderState.this.context.getCluster().getMembers()) {
                        this.commit(replica);
                    }
                }
            }
        }

        private void commitEntries() {
            LeaderState.this.context.checkThread();
            List<MemberState> members = LeaderState.this.context.getCluster().getActiveMembers((m1, m2) -> Long.compare(m2.getMatchIndex() != 0L ? m2.getMatchIndex() : 0L, m1.getMatchIndex() != 0L ? m1.getMatchIndex() : 0L));
            long commitIndex = members.get(this.quorumIndex()).getMatchIndex();
            long globalIndex = members.get(members.size() - 1).getMatchIndex();
            if (commitIndex > 0L) {
                LeaderState.this.context.setCommitIndex(commitIndex);
                LeaderState.this.context.setGlobalIndex(globalIndex);
                NavigableMap<Long, CompletableFuture<Long>> futures = this.commitFutures.headMap(commitIndex, true);
                for (Map.Entry entry : futures.entrySet()) {
                    ((CompletableFuture)entry.getValue()).complete(entry.getKey());
                }
                futures.clear();
            }
        }

        private void commit(MemberState member) {
            if (!this.committing.contains(member) && LeaderState.this.isOpen()) {
                if (LeaderState.this.context.getLog().isEmpty() || member.getNextIndex() > LeaderState.this.context.getLog().lastIndex()) {
                    this.emptyCommit(member);
                } else {
                    this.entriesCommit(member);
                }
            }
        }

        private long getPrevIndex(MemberState member) {
            return member.getNextIndex() - 1L;
        }

        private RaftEntry getPrevEntry(MemberState member, long prevIndex) {
            if (prevIndex > 0L) {
                return (RaftEntry)LeaderState.this.context.getLog().get(prevIndex);
            }
            return null;
        }

        private void emptyCommit(MemberState member) {
            long prevIndex = this.getPrevIndex(member);
            RaftEntry prevEntry = this.getPrevEntry(member, prevIndex);
            AppendRequest.Builder builder = AppendRequest.builder().withTerm(LeaderState.this.context.getTerm()).withLeader(LeaderState.this.context.getAddress().hashCode()).withLogIndex(prevIndex).withLogTerm(prevEntry != null ? prevEntry.getTerm() : 0L).withCommitIndex(LeaderState.this.context.getCommitIndex()).withGlobalIndex(LeaderState.this.context.getGlobalIndex());
            this.commit(member, builder.build(), false);
        }

        private void entriesCommit(MemberState member) {
            long prevIndex = this.getPrevIndex(member);
            RaftEntry prevEntry = this.getPrevEntry(member, prevIndex);
            AppendRequest.Builder builder = AppendRequest.builder().withTerm(LeaderState.this.context.getTerm()).withLeader(LeaderState.this.context.getAddress().hashCode()).withLogIndex(prevIndex).withLogTerm(prevEntry != null ? prevEntry.getTerm() : 0L).withCommitIndex(LeaderState.this.context.getCommitIndex()).withGlobalIndex(LeaderState.this.context.getGlobalIndex());
            if (!LeaderState.this.context.getLog().isEmpty()) {
                int size = 0;
                for (long index = prevIndex != 0L ? prevIndex + 1L : LeaderState.this.context.getLog().firstIndex(); size < 28672 && index <= LeaderState.this.context.getLog().lastIndex(); ++index) {
                    RaftEntry entry = (RaftEntry)LeaderState.this.context.getLog().get(index);
                    if (entry == null || size + entry.size() > 28672) continue;
                    size += entry.size();
                    builder.addEntry(entry);
                }
            }
            if (prevEntry != null) {
                prevEntry.release();
            }
            this.commit(member, builder.build(), true);
        }

        private void commit(MemberState member, AppendRequest request, boolean recursive) {
            this.committing.add(member);
            LeaderState.this.LOGGER.debug("{} - Sent {} to {}", new Object[]{LeaderState.this.context.getAddress(), request, member.getAddress()});
            LeaderState.this.context.getConnections().getConnection(member.getAddress()).thenAccept(connection -> connection.send((Object)request).whenComplete((response, error) -> {
                this.committing.remove(member);
                LeaderState.this.context.checkThread();
                if (LeaderState.this.isOpen()) {
                    if (error == null) {
                        LeaderState.this.LOGGER.debug("{} - Received {} from {}", new Object[]{LeaderState.this.context.getAddress(), response, member.getAddress()});
                        if (response.status() == Response.Status.OK) {
                            this.commitTime(member);
                            if (response.succeeded()) {
                                this.updateMatchIndex(member, (AppendResponse)((Object)((Object)response)));
                                this.updateNextIndex(member);
                                this.updateConfiguration(member);
                                if (recursive) {
                                    this.commitEntries();
                                }
                                if (this.hasMoreEntries(member)) {
                                    this.commit();
                                }
                            } else if (response.term() > LeaderState.this.context.getTerm()) {
                                LeaderState.this.context.setLeader(0);
                                LeaderState.this.transition(RaftServer.State.FOLLOWER);
                            } else {
                                this.resetMatchIndex(member, (AppendResponse)((Object)((Object)response)));
                                this.resetNextIndex(member);
                                if (this.hasMoreEntries(member)) {
                                    this.commit();
                                }
                            }
                        } else if (response.term() > LeaderState.this.context.getTerm()) {
                            LeaderState.this.LOGGER.debug("{} - Received higher term from {}", (Object)LeaderState.this.context.getAddress(), (Object)member.getAddress());
                            LeaderState.this.context.setLeader(0);
                            LeaderState.this.transition(RaftServer.State.FOLLOWER);
                        } else {
                            LeaderState.this.LOGGER.warn("{} - {}", (Object)LeaderState.this.context.getAddress(), response.error() != null ? response.error() : "");
                        }
                        response.release();
                    } else {
                        LeaderState.this.LOGGER.warn("{} - {}", (Object)LeaderState.this.context.getAddress(), (Object)error.getMessage());
                        if (System.currentTimeMillis() - this.commitTime() > LeaderState.this.context.getElectionTimeout().toMillis() * 2L) {
                            LeaderState.this.LOGGER.warn("{} - Suspected network partition. Stepping down", (Object)LeaderState.this.context.getAddress());
                            LeaderState.this.context.setLeader(0);
                            LeaderState.this.transition(RaftServer.State.FOLLOWER);
                        }
                    }
                } else if (response != null) {
                    response.release();
                }
            }));
        }

        private boolean hasMoreEntries(MemberState member) {
            return member.getNextIndex() < LeaderState.this.context.getLog().lastIndex();
        }

        private void updateMatchIndex(MemberState member, AppendResponse response) {
            member.setMatchIndex(Math.max(member.getMatchIndex(), response.logIndex()));
        }

        private void updateNextIndex(MemberState member) {
            member.setNextIndex(Math.max(member.getNextIndex(), Math.max(member.getMatchIndex() + 1L, 1L)));
        }

        private void updateConfiguration(MemberState member) {
            if (LeaderState.this.context.getCluster().isPassiveMember(member) && member.getMatchIndex() >= LeaderState.this.context.getCommitIndex()) {
                Collection<Address> activeMembers = LeaderState.this.context.getCluster().buildActiveMembers();
                activeMembers.add(member.getAddress());
                Collection<Address> passiveMembers = LeaderState.this.context.getCluster().buildPassiveMembers();
                passiveMembers.remove(member.getAddress());
                try (ConfigurationEntry entry = (ConfigurationEntry)LeaderState.this.context.getLog().create(ConfigurationEntry.class);){
                    ((ConfigurationEntry)((Object)entry.setTerm(LeaderState.this.context.getTerm()))).setActive(activeMembers).setPassive(passiveMembers);
                    long index = LeaderState.this.context.getLog().append((Entry)entry);
                    LeaderState.this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{LeaderState.this.context.getAddress(), entry, index});
                    LeaderState.this.context.getCluster().configure(entry.getIndex(), entry.getActive(), entry.getPassive());
                }
            }
        }

        private void resetMatchIndex(MemberState member, AppendResponse response) {
            member.setMatchIndex(response.logIndex());
            LeaderState.this.LOGGER.debug("{} - Reset match index for {} to {}", new Object[]{LeaderState.this.context.getAddress(), member, member.getMatchIndex()});
        }

        private void resetNextIndex(MemberState member) {
            if (member.getMatchIndex() != 0L) {
                member.setNextIndex(member.getMatchIndex() + 1L);
            } else {
                member.setNextIndex(LeaderState.this.context.getLog().firstIndex());
            }
            LeaderState.this.LOGGER.debug("{} - Reset next index for {} to {}", new Object[]{LeaderState.this.context.getAddress(), member, member.getNextIndex()});
        }
    }
}

