/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.JoinRequest;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.InactiveState;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalyst.util.concurrent.Scheduled;

final class JoinState
extends InactiveState {
    private Scheduled joinFuture;

    public JoinState(ServerContext context) {
        super(context);
    }

    @Override
    public CompletableFuture<AbstractState> open() {
        return ((CompletableFuture)((CompletableFuture)super.open().thenRun(this::startJoinTimeout)).thenRun(this::join)).thenApply(v -> this);
    }

    @Override
    public RaftServer.State type() {
        return RaftServer.State.JOIN;
    }

    private void startJoinTimeout() {
        this.joinFuture = this.context.getContext().schedule(() -> {
            if (this.isOpen()) {
                this.context.getCluster().setActive(true);
                this.transition(RaftServer.State.FOLLOWER);
            }
        }, this.context.getElectionTimeout());
    }

    private void join() {
        List<MemberState> votingMembers = this.context.getCluster().getActiveMembers();
        if (votingMembers.isEmpty()) {
            this.LOGGER.debug("{} - Single member cluster. Transitioning directly to leader.", (Object)this.context.getAddress());
            this.transition(RaftServer.State.LEADER);
        } else {
            this.join(this.context.getCluster().getActiveMembers().iterator());
        }
    }

    private void join(Iterator<MemberState> iterator) {
        if (iterator.hasNext()) {
            MemberState member = iterator.next();
            this.LOGGER.debug("{} - Attempting to join via {}", (Object)this.context.getAddress(), (Object)member.getAddress());
            ((CompletableFuture)this.context.getConnections().getConnection(member.getAddress()).thenCompose(connection -> {
                JoinRequest request = JoinRequest.builder().withMember(this.context.getAddress()).build();
                return connection.send((Object)request);
            })).whenComplete((response, error) -> {
                if (error == null) {
                    if (response.status() == Response.Status.OK) {
                        this.LOGGER.info("{} - Successfully joined via {}", (Object)this.context.getAddress(), (Object)member.getAddress());
                        this.context.getCluster().configure(response.version(), response.activeMembers(), response.passiveMembers());
                        if (this.context.getCluster().isActive()) {
                            this.transition(RaftServer.State.FOLLOWER);
                        } else {
                            if (!this.context.getCluster().isPassive()) throw new IllegalStateException("not a member of the cluster");
                            this.transition(RaftServer.State.PASSIVE);
                        }
                    } else {
                        this.LOGGER.debug("{} - Failed to join {}", (Object)this.context.getAddress(), (Object)member.getAddress());
                        this.join(iterator);
                    }
                    response.release();
                    return;
                } else {
                    this.LOGGER.debug("{} - Failed to join {}", (Object)this.context.getAddress(), (Object)member.getAddress());
                    this.join(iterator);
                }
            });
        } else {
            this.LOGGER.info("{} - Failed to join existing cluster", (Object)this.context.getAddress());
            this.context.getCluster().setActive(true);
            this.transition(RaftServer.State.FOLLOWER);
        }
    }

    private void cancelJoinTimeout() {
        if (this.joinFuture != null) {
            this.LOGGER.info("{} - Cancelling join timeout", (Object)this.context.getAddress());
            this.joinFuture.cancel();
            this.joinFuture = null;
        }
    }

    @Override
    public CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelJoinTimeout);
    }
}

