/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.request.KeepAliveRequest;
import net.kuujo.catalog.client.request.RegisterRequest;
import net.kuujo.catalog.client.response.KeepAliveResponse;
import net.kuujo.catalog.client.response.RegisterResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.PollRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.response.AppendResponse;
import net.kuujo.catalog.server.response.VoteResponse;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.ActiveState;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalog.server.storage.RaftEntry;
import net.kuujo.catalog.server.util.Quorum;
import net.kuujo.catalyst.util.concurrent.Scheduled;

final class FollowerState
extends ActiveState {
    private final Random random = new Random();
    private Scheduled heartbeatTimer;

    public FollowerState(ServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.State type() {
        return RaftServer.State.FOLLOWER;
    }

    @Override
    public synchronized CompletableFuture<AbstractState> open() {
        return ((CompletableFuture)super.open().thenRun(this::startHeartbeatTimeout)).thenApply(v -> this);
    }

    @Override
    protected CompletableFuture<RegisterResponse> register(RegisterRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<RegisterResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.NO_LEADER_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<KeepAliveResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.NO_LEADER_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }

    private void startHeartbeatTimeout() {
        this.LOGGER.debug("{} - Starting heartbeat timer", (Object)this.context.getAddress());
        this.resetHeartbeatTimeout();
    }

    private void resetHeartbeatTimeout() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.heartbeatTimer != null) {
            this.LOGGER.debug("{} - Reset heartbeat timeout", (Object)this.context.getAddress());
            this.heartbeatTimer.cancel();
        }
        Duration delay = this.context.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.context.getElectionTimeout().toMillis())));
        this.heartbeatTimer = this.context.getContext().schedule(() -> {
            this.heartbeatTimer = null;
            if (this.isOpen()) {
                this.context.setLeader(0);
                if (this.context.getLastVotedFor() == 0) {
                    this.LOGGER.debug("{} - Heartbeat timed out in {} milliseconds", (Object)this.context.getAddress(), (Object)delay);
                    this.sendPollRequests();
                } else {
                    this.resetHeartbeatTimeout();
                }
            }
        }, delay);
    }

    private void sendPollRequests() {
        long lastTerm;
        RaftEntry lastEntry;
        this.heartbeatTimer = this.context.getContext().schedule(() -> {
            this.LOGGER.debug("{} - Failed to poll a majority of the cluster in {} milliseconds", (Object)this.context.getAddress(), (Object)this.context.getElectionTimeout());
            this.resetHeartbeatTimeout();
        }, this.context.getElectionTimeout());
        AtomicBoolean complete = new AtomicBoolean();
        HashSet<MemberState> votingMembers = new HashSet<MemberState>(this.context.getCluster().getActiveMembers());
        if (votingMembers.isEmpty()) {
            this.LOGGER.debug("{} - Single member cluster. Transitioning directly to leader.", (Object)this.context.getAddress());
            this.transition(RaftServer.State.LEADER);
            return;
        }
        Quorum quorum = new Quorum(this.context.getCluster().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.transition(RaftServer.State.CANDIDATE);
            } else {
                this.resetHeartbeatTimeout();
            }
        });
        long lastIndex = this.context.getLog().lastIndex();
        RaftEntry raftEntry = lastEntry = lastIndex > 0L ? (RaftEntry)this.context.getLog().get(lastIndex) : null;
        if (lastEntry != null) {
            lastTerm = lastEntry.getTerm();
            lastEntry.close();
        } else {
            lastTerm = 0L;
        }
        this.LOGGER.debug("{} - Polling members {}", (Object)this.context.getAddress(), votingMembers);
        for (MemberState member : votingMembers) {
            this.LOGGER.debug("{} - Polling {} for next term {}", new Object[]{this.context.getAddress(), member, this.context.getTerm() + 1L});
            PollRequest request = PollRequest.builder().withTerm(this.context.getTerm()).withCandidate(this.context.getAddress().hashCode()).withLogIndex(lastIndex).withLogTerm(lastTerm).build();
            this.context.getConnections().getConnection(member.getAddress()).thenAccept(connection -> connection.send((Object)request).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.LOGGER.warn("{} - {}", (Object)this.context.getAddress(), (Object)error.getMessage());
                        quorum.fail();
                    } else {
                        if (response.term() > this.context.getTerm()) {
                            this.context.setTerm(response.term());
                        }
                        if (!response.accepted()) {
                            this.LOGGER.debug("{} - Received rejected poll from {}", (Object)this.context.getAddress(), (Object)member);
                            quorum.fail();
                        } else if (response.term() != this.context.getTerm()) {
                            this.LOGGER.debug("{} - Received accepted poll for a different term from {}", (Object)this.context.getAddress(), (Object)member);
                            quorum.fail();
                        } else {
                            this.LOGGER.debug("{} - Received accepted poll from {}", (Object)this.context.getAddress(), (Object)member);
                            quorum.succeed();
                        }
                        response.release();
                    }
                } else if (response != null) {
                    response.release();
                }
            }, this.context.getContext().executor()));
        }
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.resetHeartbeatTimeout();
        CompletableFuture<AppendResponse> response = super.append(request);
        this.resetHeartbeatTimeout();
        return response;
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.resetHeartbeatTimeout();
        }
        return response;
    }

    private void cancelHeartbeatTimeout() {
        if (this.heartbeatTimer != null) {
            this.LOGGER.debug("{} - Cancelling heartbeat timer", (Object)this.context.getAddress());
            this.heartbeatTimer.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelHeartbeatTimeout);
    }
}

