/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Client;
import net.kuujo.catalyst.transport.Connection;

class ConnectionManager {
    private final Client client;
    private final Map<Integer, Connection> connections = new HashMap<Integer, Connection>();

    public ConnectionManager(Client client) {
        this.client = client;
    }

    public CompletableFuture<Connection> getConnection(Address address) {
        Connection connection = this.connections.get(address.hashCode());
        return connection == null ? this.createConnection(address) : CompletableFuture.completedFuture(connection);
    }

    private CompletableFuture<Connection> createConnection(Address address) {
        return this.client.connect(address).thenApply(connection -> {
            this.connections.put(address.hashCode(), (Connection)connection);
            return connection;
        });
    }

    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        return CompletableFuture.allOf(futures);
    }
}

