/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.util.Assert;

class ClusterState {
    private final ServerContext context;
    private final Address address;
    private Type type = Type.PASSIVE;
    private long version = -1L;
    private final Map<Integer, MemberState> membersMap = new HashMap<Integer, MemberState>();
    private final Map<Integer, Type> types = new HashMap<Integer, Type>();
    private final List<MemberState> members = new ArrayList<MemberState>();
    private final List<MemberState> activeMembers = new ArrayList<MemberState>();
    private final List<MemberState> passiveMembers = new ArrayList<MemberState>();

    ClusterState(ServerContext context, Address address) {
        this.context = (ServerContext)Assert.notNull((Object)context, (String)"context");
        this.address = (Address)Assert.notNull((Object)address, (String)"address");
    }

    Address getAddress() {
        return this.address;
    }

    boolean isActive() {
        return this.type == Type.ACTIVE;
    }

    ClusterState setActive(boolean active) {
        this.type = active ? Type.ACTIVE : Type.PASSIVE;
        return this;
    }

    boolean isPassive() {
        return this.type == Type.PASSIVE;
    }

    ClusterState setPassive(boolean passive) {
        this.type = passive ? Type.PASSIVE : Type.ACTIVE;
        return this;
    }

    int getQuorum() {
        return (int)Math.ceil((double)this.activeMembers.size() / 2.0);
    }

    long getVersion() {
        return this.version;
    }

    private ClusterState clearMembers() {
        this.members.clear();
        this.activeMembers.clear();
        this.passiveMembers.clear();
        this.membersMap.clear();
        this.types.clear();
        return this;
    }

    MemberState getMember(int id) {
        return this.membersMap.get(id);
    }

    boolean isActiveMember(MemberState member) {
        return this.types.get(member.getAddress().hashCode()) == Type.ACTIVE;
    }

    boolean isPassiveMember(MemberState member) {
        return this.types.get(member.getAddress().hashCode()) == Type.PASSIVE;
    }

    List<MemberState> getPassiveMembers() {
        return this.passiveMembers;
    }

    List<MemberState> getPassiveMembers(Comparator<MemberState> comparator) {
        Collections.sort(this.passiveMembers, comparator);
        return this.passiveMembers;
    }

    List<MemberState> getActiveMembers() {
        return this.activeMembers;
    }

    List<MemberState> getActiveMembers(Comparator<MemberState> comparator) {
        Collections.sort(this.activeMembers, comparator);
        return this.activeMembers;
    }

    List<MemberState> getMembers() {
        return this.members;
    }

    ClusterState configure(long version, Collection<Address> activeMembers, Collection<Address> passiveMembers) {
        if (version <= this.version) {
            return this;
        }
        List<MemberState> newActiveMembers = this.buildMembers(activeMembers);
        List<MemberState> newPassiveMembers = this.buildMembers(passiveMembers);
        this.clearMembers();
        for (MemberState member : newActiveMembers) {
            this.membersMap.put(member.getAddress().hashCode(), member);
            this.members.add(member);
            this.activeMembers.add(member);
            this.types.put(member.getAddress().hashCode(), Type.ACTIVE);
        }
        for (MemberState member : newPassiveMembers) {
            this.membersMap.put(member.getAddress().hashCode(), member);
            this.members.add(member);
            this.passiveMembers.add(member);
            this.types.put(member.getAddress().hashCode(), Type.PASSIVE);
        }
        this.type = activeMembers.contains(this.address) ? Type.ACTIVE : (passiveMembers.contains(this.address) ? Type.PASSIVE : null);
        this.version = version;
        return this;
    }

    Collection<Address> buildActiveMembers() {
        ArrayList<Address> members = new ArrayList<Address>();
        for (MemberState state : this.activeMembers) {
            members.add(state.getAddress());
        }
        members.add(this.address);
        return members;
    }

    Collection<Address> buildPassiveMembers() {
        ArrayList<Address> members = new ArrayList<Address>();
        for (MemberState state : this.passiveMembers) {
            members.add(state.getAddress());
        }
        return members;
    }

    private List<MemberState> buildMembers(Collection<Address> members) {
        ArrayList<MemberState> states = new ArrayList<MemberState>(members.size());
        for (Address address : members) {
            if (address.equals((Object)this.address)) continue;
            MemberState state = this.membersMap.get(address.hashCode());
            if (state == null) {
                state = new MemberState(address);
                state.setNextIndex(Math.max(state.getMatchIndex(), Math.max(this.context.getLog().lastIndex(), 1L)));
            }
            states.add(state);
        }
        return states;
    }

    private static enum Type {
        ACTIVE,
        PASSIVE;

    }
}

