/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.response.AppendResponse;
import net.kuujo.catalog.server.response.VoteResponse;
import net.kuujo.catalog.server.state.AbstractState;
import net.kuujo.catalog.server.state.ActiveState;
import net.kuujo.catalog.server.state.MemberState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalog.server.storage.RaftEntry;
import net.kuujo.catalog.server.util.Quorum;
import net.kuujo.catalyst.util.concurrent.Scheduled;

final class CandidateState
extends ActiveState {
    private final Random random = new Random();
    private Quorum quorum;
    private Scheduled currentTimer;

    public CandidateState(ServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.State type() {
        return RaftServer.State.CANDIDATE;
    }

    @Override
    public synchronized CompletableFuture<AbstractState> open() {
        return ((CompletableFuture)super.open().thenRun(this::startElection)).thenApply(v -> this);
    }

    private void startElection() {
        this.LOGGER.info("{} - Starting election", (Object)this.context.getAddress());
        this.sendVoteRequests();
    }

    private void sendVoteRequests() {
        long lastTerm;
        RaftEntry lastEntry;
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
        }
        this.context.setTerm(this.context.getTerm() + 1L);
        Duration delay = this.context.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.context.getElectionTimeout().toMillis())));
        this.currentTimer = this.context.getContext().schedule(() -> {
            this.LOGGER.debug("{} - Election timed out", (Object)this.context.getAddress());
            if (this.quorum != null) {
                this.quorum.cancel();
                this.quorum = null;
            }
            this.sendVoteRequests();
            this.LOGGER.debug("{} - Restarted election", (Object)this.context.getAddress());
        }, delay);
        AtomicBoolean complete = new AtomicBoolean();
        HashSet<MemberState> votingMembers = new HashSet<MemberState>(this.context.getCluster().getActiveMembers());
        if (votingMembers.isEmpty()) {
            this.LOGGER.debug("{} - Single member cluster. Transitioning directly to leader.", (Object)this.context.getAddress());
            this.transition(RaftServer.State.LEADER);
            return;
        }
        Quorum quorum = new Quorum(this.context.getCluster().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.transition(RaftServer.State.LEADER);
            }
        });
        long lastIndex = this.context.getLog().lastIndex();
        RaftEntry raftEntry = lastEntry = lastIndex != 0L ? (RaftEntry)this.context.getLog().get(lastIndex) : null;
        if (lastEntry != null) {
            lastTerm = lastEntry.getTerm();
            lastEntry.close();
        } else {
            lastTerm = 0L;
        }
        this.LOGGER.debug("{} - Requesting votes from {}", (Object)this.context.getAddress(), votingMembers);
        for (MemberState member : votingMembers) {
            this.LOGGER.debug("{} - Requesting vote from {} for term {}", new Object[]{this.context.getAddress(), member, this.context.getTerm()});
            VoteRequest request = VoteRequest.builder().withTerm(this.context.getTerm()).withCandidate(this.context.getAddress().hashCode()).withLogIndex(lastIndex).withLogTerm(lastTerm).build();
            this.context.getConnections().getConnection(member.getAddress()).thenAccept(connection -> connection.send((Object)request).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.LOGGER.warn(error.getMessage());
                        quorum.fail();
                    } else {
                        if (response.term() > this.context.getTerm()) {
                            this.LOGGER.debug("{} - Received greater term from {}", (Object)this.context.getAddress(), (Object)member);
                            this.context.setTerm(response.term());
                            complete.set(true);
                            this.transition(RaftServer.State.FOLLOWER);
                        } else if (!response.voted()) {
                            this.LOGGER.debug("{} - Received rejected vote from {}", (Object)this.context.getAddress(), (Object)member);
                            quorum.fail();
                        } else if (response.term() != this.context.getTerm()) {
                            this.LOGGER.debug("{} - Received successful vote for a different term from {}", (Object)this.context.getAddress(), (Object)member);
                            quorum.fail();
                        } else {
                            this.LOGGER.debug("{} - Received successful vote from {}", (Object)this.context.getAddress(), (Object)member);
                            quorum.succeed();
                        }
                        response.release();
                    }
                } else if (response != null) {
                    response.release();
                }
            }, this.context.getContext().executor()));
        }
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        if (request.term() >= this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.transition(RaftServer.State.FOLLOWER);
        }
        return super.append(request);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        this.context.checkThread();
        if (request.term() > this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.transition(RaftServer.State.FOLLOWER);
            return super.vote(request);
        }
        request.release();
        if (request.candidate() == this.context.getAddress().hashCode()) {
            return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build()));
        }
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build()));
    }

    private void cancelElection() {
        this.context.checkThread();
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Cancelling election", (Object)this.context.getAddress());
            this.currentTimer.cancel();
        }
        if (this.quorum != null) {
            this.quorum.cancel();
            this.quorum = null;
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelElection);
    }
}

