/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import net.kuujo.catalog.client.ConsistencyLevel;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.error.RaftException;
import net.kuujo.catalog.client.request.CommandRequest;
import net.kuujo.catalog.client.request.QueryRequest;
import net.kuujo.catalog.client.request.Request;
import net.kuujo.catalog.client.response.AbstractResponse;
import net.kuujo.catalog.client.response.CommandResponse;
import net.kuujo.catalog.client.response.QueryResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.PollRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.response.AppendResponse;
import net.kuujo.catalog.server.response.PollResponse;
import net.kuujo.catalog.server.response.VoteResponse;
import net.kuujo.catalog.server.state.PassiveState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.QueryEntry;
import net.kuujo.catalog.server.storage.RaftEntry;

abstract class ActiveState
extends PassiveState {
    protected ActiveState(ServerContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<AppendResponse> append(AppendRequest request) {
        try {
            this.context.checkThread();
            boolean transition = false;
            if (request.term() > this.context.getTerm() || request.term() == this.context.getTerm() && this.context.getLeader() == null) {
                this.context.setTerm(request.term());
                this.context.setLeader(request.leader());
                transition = true;
            }
            CompletableFuture<AppendResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleAppend(this.logRequest(request))));
            if (transition) {
                this.transition(RaftServer.State.FOLLOWER);
            }
            CompletableFuture<AppendResponse> completableFuture = future;
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<PollResponse> poll(PollRequest request) {
        try {
            this.context.checkThread();
            CompletableFuture<PollResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(this.handlePoll(this.logRequest(request))));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    protected PollResponse handlePoll(PollRequest request) {
        if (this.logUpToDate(request.logIndex(), request.logTerm(), (Request)request)) {
            return ((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(true).build();
        }
        return ((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build();
    }

    @Override
    protected CompletableFuture<VoteResponse> vote(VoteRequest request) {
        try {
            this.context.checkThread();
            CompletableFuture<VoteResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(this.handleVote(this.logRequest(request))));
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    protected VoteResponse handleVote(VoteRequest request) {
        if (request.term() > this.context.getTerm()) {
            this.context.setTerm(request.term());
        }
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.debug("{} - Rejected {}: candidate's term is less than the current term", (Object)this.context.getAddress(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (!this.context.getCluster().getActiveMembers().stream().map(m -> m.getAddress().hashCode()).collect(Collectors.toSet()).contains(request.candidate())) {
            this.LOGGER.debug("{} - Rejected {}: candidate is not known to the local member", (Object)this.context.getAddress(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLastVotedFor() == 0 || this.context.getLastVotedFor() == request.candidate()) {
            if (this.logUpToDate(request.logIndex(), request.logTerm(), (Request)request)) {
                this.context.setLastVotedFor(request.candidate());
                return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build();
            }
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        this.LOGGER.debug("{} - Rejected {}: already voted for {}", new Object[]{this.context.getAddress(), request, this.context.getLastVotedFor()});
        return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean logUpToDate(long index, long term, Request request) {
        if (this.context.getLog().isEmpty()) {
            this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getAddress(), (Object)request);
            return true;
        }
        long lastIndex = this.context.getLog().lastIndex();
        RaftEntry entry = (RaftEntry)this.context.getLog().get(lastIndex);
        if (entry == null) {
            this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getAddress(), (Object)request);
            return true;
        }
        try {
            if (index != 0L && index >= lastIndex) {
                if (term >= entry.getTerm()) {
                    this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getAddress(), (Object)request);
                    boolean bl = true;
                    return bl;
                }
                this.LOGGER.debug("{} - Rejected {}: candidate's last log term ({}) is in conflict with local log ({})", new Object[]{this.context.getAddress(), request, term, entry.getTerm()});
                boolean bl = false;
                return bl;
            }
            this.LOGGER.debug("{} - Rejected {}: candidate's last log entry ({}) is at a lower index than the local log ({})", new Object[]{this.context.getAddress(), request, index, lastIndex});
            boolean bl = false;
            return bl;
        }
        finally {
            entry.close();
        }
    }

    @Override
    protected CompletableFuture<CommandResponse> command(CommandRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (this.context.getLeader() == null) {
                CompletableFuture<AbstractResponse> completableFuture = CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.NO_LEADER_ERROR)).build()));
                return completableFuture;
            }
            CompletionStage completionStage = this.forward(request).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            request.release();
        }
    }

    @Override
    protected CompletableFuture<QueryResponse> query(QueryRequest request) {
        try {
            this.context.checkThread();
            this.logRequest(request);
            if (request.query().consistency() == ConsistencyLevel.SERIALIZABLE) {
                CompletableFuture<QueryResponse> completableFuture = this.querySerializable(request);
                return completableFuture;
            }
            CompletableFuture<QueryResponse> completableFuture = this.queryForward(request);
            return completableFuture;
        }
        finally {
            request.release();
        }
    }

    private CompletableFuture<QueryResponse> queryForward(QueryRequest request) {
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.NO_LEADER_ERROR)).build()));
        }
        this.LOGGER.debug("{} - Forwarded {}", (Object)this.context.getAddress(), (Object)request);
        return this.forward(request).thenApply(this::logResponse);
    }

    private CompletableFuture<QueryResponse> querySerializable(QueryRequest request) {
        if (this.context.getLog().lastIndex() < this.context.getCommitIndex()) {
            this.LOGGER.debug("{} - State appears to be out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        QueryEntry entry = ((QueryEntry)((Object)((QueryEntry)((Object)((QueryEntry)((Object)((QueryEntry)((QueryEntry)this.context.getLog().create(QueryEntry.class)).setIndex(this.context.getCommitIndex())).setTerm(this.context.getTerm()))).setTimestamp(System.currentTimeMillis()))).setSession(request.session()))).setVersion(request.version()).setQuery(request.query());
        long version = this.context.getLastApplied();
        this.context.getStateMachine().apply((Entry)entry).whenCompleteAsync((result, error) -> {
            if (this.isOpen()) {
                if (error == null) {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.OK)).withVersion(version).withResult(result).build()));
                } else if (error instanceof RaftException) {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withVersion(version).withError((RaftError)((RaftException)error).getType())).build()));
                } else {
                    future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((RaftError)RaftError.Type.INTERNAL_ERROR)).build()));
                }
            }
            entry.release();
        }, this.context.getContext().executor());
        return future;
    }
}

