/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.concurrent.CompletableFuture;
import net.kuujo.catalog.client.request.CommandRequest;
import net.kuujo.catalog.client.request.KeepAliveRequest;
import net.kuujo.catalog.client.request.QueryRequest;
import net.kuujo.catalog.client.request.RegisterRequest;
import net.kuujo.catalog.client.request.Request;
import net.kuujo.catalog.client.response.CommandResponse;
import net.kuujo.catalog.client.response.KeepAliveResponse;
import net.kuujo.catalog.client.response.QueryResponse;
import net.kuujo.catalog.client.response.RegisterResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalog.server.RaftServer;
import net.kuujo.catalog.server.request.AppendRequest;
import net.kuujo.catalog.server.request.JoinRequest;
import net.kuujo.catalog.server.request.LeaveRequest;
import net.kuujo.catalog.server.request.PollRequest;
import net.kuujo.catalog.server.request.VoteRequest;
import net.kuujo.catalog.server.response.AppendResponse;
import net.kuujo.catalog.server.response.JoinResponse;
import net.kuujo.catalog.server.response.LeaveResponse;
import net.kuujo.catalog.server.response.PollResponse;
import net.kuujo.catalog.server.response.VoteResponse;
import net.kuujo.catalog.server.state.CandidateState;
import net.kuujo.catalog.server.state.FollowerState;
import net.kuujo.catalog.server.state.InactiveState;
import net.kuujo.catalog.server.state.LeaderState;
import net.kuujo.catalog.server.state.PassiveState;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalyst.util.Managed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractState
implements Managed<AbstractState> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final ServerContext context;
    private volatile boolean open;

    protected AbstractState(ServerContext context) {
        this.context = context;
    }

    public abstract RaftServer.State type();

    protected final <R extends Request> R logRequest(R request) {
        this.LOGGER.debug("{} - Received {}", (Object)this.context.getAddress(), request);
        return request;
    }

    protected final <R extends Response> R logResponse(R response) {
        this.LOGGER.debug("{} - Sent {}", (Object)this.context.getAddress(), response);
        return response;
    }

    public CompletableFuture<AbstractState> open() {
        this.context.checkThread();
        this.open = true;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void transition(RaftServer.State state) {
        if (state == this.type()) {
            return;
        }
        switch (state) {
            case INACTIVE: {
                this.context.transition(InactiveState.class);
                break;
            }
            case PASSIVE: {
                this.context.transition(PassiveState.class);
                break;
            }
            case FOLLOWER: {
                this.context.transition(FollowerState.class);
                break;
            }
            case CANDIDATE: {
                this.context.transition(CandidateState.class);
                break;
            }
            case LEADER: {
                this.context.transition(LeaderState.class);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected abstract CompletableFuture<RegisterResponse> register(RegisterRequest var1);

    protected abstract CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest var1);

    protected abstract CompletableFuture<JoinResponse> join(JoinRequest var1);

    protected abstract CompletableFuture<LeaveResponse> leave(LeaveRequest var1);

    protected abstract CompletableFuture<AppendResponse> append(AppendRequest var1);

    protected abstract CompletableFuture<PollResponse> poll(PollRequest var1);

    protected abstract CompletableFuture<VoteResponse> vote(VoteRequest var1);

    protected abstract CompletableFuture<CommandResponse> command(CommandRequest var1);

    protected abstract CompletableFuture<QueryResponse> query(QueryRequest var1);

    public CompletableFuture<Void> close() {
        this.context.checkThread();
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return String.format("%s[context=%s]", this.getClass().getSimpleName(), this.context);
    }
}

