/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.response;

import java.util.Objects;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.response.AbstractResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.BuilderPool;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=275)
public class VoteResponse
extends AbstractResponse<VoteResponse> {
    public static final byte TYPE = 18;
    private static final BuilderPool<Builder, VoteResponse> POOL = new BuilderPool(Builder::new);
    private long term;
    private boolean voted;

    public static Builder builder() {
        return (Builder)POOL.acquire();
    }

    public static Builder builder(VoteResponse response) {
        return (Builder)POOL.acquire((Object)response);
    }

    public VoteResponse(ReferenceManager<VoteResponse> referenceManager) {
        super(referenceManager);
    }

    public byte type() {
        return 18;
    }

    public long term() {
        return this.term;
    }

    public boolean voted() {
        return this.voted;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId((int)buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.term = buffer.readLong();
            this.voted = buffer.readBoolean();
        } else {
            this.error = RaftError.forId((int)buffer.readByte());
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte((int)this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.term).writeBoolean(this.voted);
        } else {
            buffer.writeByte((int)this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.status, this.term, this.voted);
    }

    public boolean equals(Object object) {
        if (object instanceof VoteResponse) {
            VoteResponse response = (VoteResponse)((Object)object);
            return response.status == this.status && response.term == this.term && response.voted == this.voted;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[status=%s, term=%d, voted=%b]", ((Object)((Object)this)).getClass().getSimpleName(), this.status, this.term, this.voted);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, VoteResponse> {
        protected Builder(BuilderPool<Builder, VoteResponse> pool) {
            super(pool, VoteResponse::new);
        }

        protected void reset() {
            super.reset();
            ((VoteResponse)this.response).term = 0L;
            ((VoteResponse)this.response).voted = false;
        }

        public Builder withTerm(long term) {
            ((VoteResponse)this.response).term = (Long)Assert.argNot((Object)term, (term < 0L ? 1 : 0) != 0, (String)"term cannot be negative", (Object[])new Object[0]);
            return this;
        }

        public Builder withVoted(boolean voted) {
            ((VoteResponse)this.response).voted = voted;
            return this;
        }

        public VoteResponse build() {
            super.build();
            if (((VoteResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot((((VoteResponse)this.response).term < 0L ? 1 : 0) != 0, (String)"term cannot be negative", (Object[])new Object[0]);
            }
            return (VoteResponse)this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((VoteResponse)((Builder)((Object)object)).response).equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.response);
        }
    }
}

