/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.response;

import java.util.Collection;
import java.util.Objects;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.response.AbstractResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.BuilderPool;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=261)
public class JoinResponse
extends AbstractResponse<JoinResponse> {
    public static final byte TYPE = 12;
    private static final BuilderPool<Builder, JoinResponse> POOL = new BuilderPool(Builder::new);
    private long version;
    private Collection<Address> activeMembers;
    private Collection<Address> passiveMembers;

    public static Builder builder() {
        return (Builder)POOL.acquire();
    }

    public static Builder builder(JoinResponse response) {
        return (Builder)POOL.acquire((Object)response);
    }

    public JoinResponse(ReferenceManager<JoinResponse> referenceManager) {
        super(referenceManager);
    }

    public byte type() {
        return 12;
    }

    public long version() {
        return this.version;
    }

    public Collection<Address> activeMembers() {
        return this.activeMembers;
    }

    public Collection<Address> passiveMembers() {
        return this.passiveMembers;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId((int)buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.version = buffer.readLong();
            this.activeMembers = (Collection)serializer.readObject(buffer);
            this.passiveMembers = (Collection)serializer.readObject(buffer);
        } else {
            this.error = RaftError.forId((int)buffer.readByte());
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte((int)this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.version);
            serializer.writeObject(this.activeMembers, buffer);
            serializer.writeObject(this.passiveMembers, buffer);
        } else {
            buffer.writeByte((int)this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.status, this.version, this.activeMembers, this.passiveMembers);
    }

    public boolean equals(Object object) {
        if (object instanceof JoinResponse) {
            JoinResponse response = (JoinResponse)((Object)object);
            return response.status == this.status && response.version == this.version && response.activeMembers.equals(this.activeMembers) && response.passiveMembers.equals(this.passiveMembers);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[status=%s, version=%d, activeMembers=%b, passiveMembers=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.status, this.version, this.activeMembers, this.passiveMembers);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, JoinResponse> {
        protected Builder(BuilderPool<Builder, JoinResponse> pool) {
            super(pool, JoinResponse::new);
        }

        protected void reset() {
            super.reset();
            ((JoinResponse)this.response).version = 0L;
            ((JoinResponse)this.response).activeMembers = null;
            ((JoinResponse)this.response).passiveMembers = null;
        }

        public Builder withVersion(long version) {
            ((JoinResponse)this.response).version = (Long)Assert.argNot((Object)version, (version < 0L ? 1 : 0) != 0, (String)"version cannot be negative", (Object[])new Object[0]);
            return this;
        }

        public Builder withActiveMembers(Collection<Address> members) {
            ((JoinResponse)this.response).activeMembers = (Collection)Assert.notNull(members, (String)"members");
            return this;
        }

        public Builder withPassiveMembers(Collection<Address> members) {
            ((JoinResponse)this.response).passiveMembers = (Collection)Assert.notNull(members, (String)"members");
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((JoinResponse)((Builder)((Object)object)).response).equals(this.response);
        }

        public JoinResponse build() {
            super.build();
            if (((JoinResponse)this.response).status == Response.Status.OK) {
                Assert.state((((JoinResponse)this.response).activeMembers != null ? 1 : 0) != 0, (String)"activeMembers members cannot be null", (Object[])new Object[0]);
                Assert.state((((JoinResponse)this.response).passiveMembers != null ? 1 : 0) != 0, (String)"passiveMembers members cannot be null", (Object[])new Object[0]);
            }
            return (JoinResponse)this.response;
        }

        public String toString() {
            return String.format("%s[response=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.response);
        }
    }
}

