/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.response;

import java.util.Objects;
import net.kuujo.catalog.client.error.RaftError;
import net.kuujo.catalog.client.response.AbstractResponse;
import net.kuujo.catalog.client.response.Response;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.BuilderPool;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=257)
public class AppendResponse
extends AbstractResponse<AppendResponse> {
    public static final byte TYPE = 20;
    private static final BuilderPool<Builder, AppendResponse> POOL = new BuilderPool(Builder::new);
    private long term;
    private boolean succeeded;
    private long logIndex;

    public static Builder builder() {
        return (Builder)POOL.acquire();
    }

    public static Builder builder(AppendResponse response) {
        return (Builder)POOL.acquire((Object)response);
    }

    public AppendResponse(ReferenceManager<AppendResponse> referenceManager) {
        super(referenceManager);
    }

    public byte type() {
        return 20;
    }

    public long term() {
        return this.term;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId((int)buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.term = buffer.readLong();
            this.succeeded = buffer.readBoolean();
            this.logIndex = buffer.readLong();
        } else {
            this.error = RaftError.forId((int)buffer.readByte());
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte((int)this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.term).writeBoolean(this.succeeded).writeLong(this.logIndex);
        } else {
            buffer.writeByte((int)this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.status, this.term, this.succeeded, this.logIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof AppendResponse) {
            AppendResponse response = (AppendResponse)((Object)object);
            return response.status == this.status && response.term == this.term && response.succeeded == this.succeeded && response.logIndex == this.logIndex;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[status=%s, term=%d, succeeded=%b, logIndex=%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.status, this.term, this.succeeded, this.logIndex);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, AppendResponse> {
        protected Builder(BuilderPool<Builder, AppendResponse> pool) {
            super(pool, AppendResponse::new);
        }

        public Builder withTerm(long term) {
            ((AppendResponse)this.response).term = (Long)Assert.argNot((Object)term, (term <= 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withSucceeded(boolean succeeded) {
            ((AppendResponse)this.response).succeeded = succeeded;
            return this;
        }

        public Builder withLogIndex(long index) {
            ((AppendResponse)this.response).logIndex = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"term must not be negative", (Object[])new Object[0]);
            return this;
        }

        public AppendResponse build() {
            super.build();
            if (((AppendResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot((((AppendResponse)this.response).term <= 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
                Assert.stateNot((((AppendResponse)this.response).logIndex < 0L ? 1 : 0) != 0, (String)"log index must be positive", (Object[])new Object[0]);
            }
            return (AppendResponse)this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((AppendResponse)((Builder)((Object)object)).response).equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.response);
        }
    }
}

