/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.request;

import java.util.Objects;
import net.kuujo.catalog.client.request.AbstractRequest;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.BuilderPool;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=274)
public class VoteRequest
extends AbstractRequest<VoteRequest> {
    public static final byte TYPE = 17;
    private static final BuilderPool<Builder, VoteRequest> POOL = new BuilderPool(Builder::new);
    private long term = -1L;
    private int candidate;
    private long logIndex = -1L;
    private long logTerm = -1L;

    public static Builder builder() {
        return (Builder)POOL.acquire();
    }

    public static Builder builder(VoteRequest request) {
        return (Builder)POOL.acquire((Object)request);
    }

    public VoteRequest(ReferenceManager<VoteRequest> referenceManager) {
        super(referenceManager);
    }

    public byte type() {
        return 17;
    }

    public long term() {
        return this.term;
    }

    public int candidate() {
        return this.candidate;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public long logTerm() {
        return this.logTerm;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.term = buffer.readLong();
        this.candidate = buffer.readInt();
        this.logIndex = buffer.readLong();
        this.logTerm = buffer.readLong();
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeLong(this.term).writeInt(this.candidate).writeLong(this.logIndex).writeLong(this.logTerm);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public boolean equals(Object object) {
        if (object instanceof VoteRequest) {
            VoteRequest request = (VoteRequest)((Object)object);
            return request.term == this.term && request.candidate == this.candidate && request.logIndex == this.logIndex && request.logTerm == this.logTerm;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[term=%d, candidate=%s, logIndex=%d, logTerm=%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, VoteRequest> {
        protected Builder(BuilderPool<Builder, VoteRequest> pool) {
            super(pool, VoteRequest::new);
        }

        protected void reset() {
            super.reset();
            ((VoteRequest)this.request).term = -1L;
            ((VoteRequest)this.request).candidate = 0;
            ((VoteRequest)this.request).logIndex = -1L;
            ((VoteRequest)this.request).logTerm = -1L;
        }

        public Builder withTerm(long term) {
            ((VoteRequest)this.request).term = (Long)Assert.argNot((Object)term, (term < 0L ? 1 : 0) != 0, (String)"term must not be negative", (Object[])new Object[0]);
            return this;
        }

        public Builder withCandidate(int candidate) {
            ((VoteRequest)this.request).candidate = candidate;
            return this;
        }

        public Builder withLogIndex(long index) {
            ((VoteRequest)this.request).logIndex = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"log index must not be negative", (Object[])new Object[0]);
            return this;
        }

        public Builder withLogTerm(long term) {
            ((VoteRequest)this.request).logTerm = (Long)Assert.argNot((Object)term, (term < 0L ? 1 : 0) != 0, (String)"log term must not be negative", (Object[])new Object[0]);
            return this;
        }

        public VoteRequest build() {
            super.build();
            Assert.stateNot((((VoteRequest)this.request).term < 0L ? 1 : 0) != 0, (String)"term must not be negative", (Object[])new Object[0]);
            Assert.stateNot((((VoteRequest)this.request).logIndex < 0L ? 1 : 0) != 0, (String)"log index must not be negative", (Object[])new Object[0]);
            Assert.stateNot((((VoteRequest)this.request).logTerm < 0L ? 1 : 0) != 0, (String)"log term must not be negative", (Object[])new Object[0]);
            return (VoteRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((VoteRequest)((Builder)((Object)object)).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.request);
        }
    }
}

