/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.request;

import java.util.Objects;
import net.kuujo.catalog.client.request.AbstractRequest;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.BufferOutput;
import net.kuujo.catalyst.serializer.SerializeWith;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.BuilderPool;
import net.kuujo.catalyst.util.ReferenceManager;

@SerializeWith(id=260)
public class JoinRequest
extends AbstractRequest<JoinRequest> {
    public static final byte TYPE = 11;
    private static final BuilderPool<Builder, JoinRequest> POOL = new BuilderPool(Builder::new);
    private Address member;

    public static Builder builder() {
        return (Builder)POOL.acquire();
    }

    public static Builder builder(JoinRequest request) {
        return (Builder)POOL.acquire((Object)request);
    }

    private JoinRequest(ReferenceManager<JoinRequest> referenceManager) {
        super(referenceManager);
    }

    public byte type() {
        return 11;
    }

    public Address member() {
        return this.member;
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        serializer.writeObject((Object)this.member, buffer);
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.member = (Address)serializer.readObject(buffer);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (object instanceof JoinRequest) {
            JoinRequest request = (JoinRequest)((Object)object);
            return request.member.equals((Object)this.member);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[member=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.member);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, JoinRequest> {
        protected Builder(BuilderPool<Builder, JoinRequest> pool) {
            super(pool, x$0 -> new JoinRequest(x$0));
        }

        public void reset() {
            super.reset();
            ((JoinRequest)this.request).member = null;
        }

        public Builder withMember(Address member) {
            ((JoinRequest)this.request).member = (Address)Assert.notNull((Object)member, (String)"member");
            return this;
        }

        public JoinRequest build() {
            super.build();
            Assert.state((((JoinRequest)this.request).member != null ? 1 : 0) != 0, (String)"member cannot be null", (Object[])new Object[0]);
            return (JoinRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((JoinRequest)((Builder)((Object)object)).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.request);
        }
    }
}

