/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kuujo.catalog.server.StateMachine;
import net.kuujo.catalog.server.state.ServerContext;
import net.kuujo.catalog.server.storage.Storage;
import net.kuujo.catalyst.buffer.BufferAllocator;
import net.kuujo.catalyst.buffer.PooledDirectAllocator;
import net.kuujo.catalyst.serializer.SerializableTypeResolver;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.serializer.ServiceLoaderTypeResolver;
import net.kuujo.catalyst.transport.Address;
import net.kuujo.catalyst.transport.Transport;
import net.kuujo.catalyst.util.Assert;
import net.kuujo.catalyst.util.ConfigurationException;
import net.kuujo.catalyst.util.Managed;
import net.kuujo.catalyst.util.concurrent.Context;

public class RaftServer
implements Managed<RaftServer> {
    private final ServerContext context;
    private CompletableFuture<RaftServer> openFuture;
    private CompletableFuture<Void> closeFuture;
    private boolean open;

    public static Builder builder(Address address, Address ... cluster) {
        return RaftServer.builder(address, Arrays.asList(cluster));
    }

    public static Builder builder(Address address, Collection<Address> cluster) {
        return new Builder(address, cluster);
    }

    private RaftServer(ServerContext context) {
        this.context = context;
    }

    public long term() {
        return this.context.getTerm();
    }

    public Address leader() {
        return this.context.getLeader();
    }

    public Context context() {
        return this.context.getContext();
    }

    public State state() {
        return this.context.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftServer> open() {
        if (this.open) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            RaftServer raftServer = this;
            synchronized (raftServer) {
                if (this.openFuture == null) {
                    this.openFuture = this.closeFuture == null ? this.context.open().thenApply(c -> {
                        this.openFuture = null;
                        this.open = true;
                        return this;
                    }) : this.closeFuture.thenCompose(v -> this.context.open().thenApply(c -> {
                        this.openFuture = null;
                        this.open = true;
                        return this;
                    }));
                }
            }
        }
        return this.openFuture;
    }

    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> close() {
        if (!this.open) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            RaftServer raftServer = this;
            synchronized (raftServer) {
                if (this.closeFuture == null) {
                    this.closeFuture = this.openFuture == null ? this.context.close().thenRun(() -> {
                        this.closeFuture = null;
                        this.open = false;
                    }) : this.openFuture.thenCompose(c -> this.context.close().thenRun(() -> {
                        this.closeFuture = null;
                        this.open = false;
                    }));
                }
            }
        }
        return this.closeFuture;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public CompletableFuture<Void> delete() {
        return this.close().thenRun(this.context::delete);
    }

    public static class Builder
    extends net.kuujo.catalyst.util.Builder<RaftServer> {
        private static final Duration DEFAULT_RAFT_ELECTION_TIMEOUT = Duration.ofMillis(500L);
        private static final Duration DEFAULT_RAFT_HEARTBEAT_INTERVAL = Duration.ofMillis(150L);
        private static final Duration DEFAULT_RAFT_SESSION_TIMEOUT = Duration.ofMillis(5000L);
        private Transport transport;
        private Storage storage;
        private Serializer serializer;
        private StateMachine stateMachine;
        private Address address;
        private Set<Address> cluster;
        private Duration electionTimeout = DEFAULT_RAFT_ELECTION_TIMEOUT;
        private Duration heartbeatInterval = DEFAULT_RAFT_HEARTBEAT_INTERVAL;
        private Duration sessionTimeout = DEFAULT_RAFT_SESSION_TIMEOUT;

        private Builder(Address address, Collection<Address> cluster) {
            this.address = (Address)Assert.notNull((Object)address, (String)"address");
            this.cluster = new HashSet<Address>((Collection)Assert.notNull(cluster, (String)"cluster"));
            this.cluster.add(address);
        }

        public Builder withTransport(Transport transport) {
            this.transport = (Transport)Assert.notNull((Object)transport, (String)"transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.storage = (Storage)Assert.notNull((Object)storage, (String)"storage");
            return this;
        }

        public Builder withStateMachine(StateMachine stateMachine) {
            this.stateMachine = (StateMachine)Assert.notNull((Object)stateMachine, (String)"stateMachine");
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            Assert.argNot((electionTimeout.isNegative() || electionTimeout.isZero() ? 1 : 0) != 0, (String)"electionTimeout must be positive", (Object[])new Object[0]);
            Assert.argNot((electionTimeout.toMillis() <= this.heartbeatInterval.toMillis() ? 1 : 0) != 0, (String)"electionTimeout must be greater than heartbeatInterval", (Object[])new Object[0]);
            this.electionTimeout = (Duration)Assert.notNull((Object)electionTimeout, (String)"electionTimeout");
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            Assert.argNot((heartbeatInterval.isNegative() || heartbeatInterval.isZero() ? 1 : 0) != 0, (String)"sessionTimeout must be positive", (Object[])new Object[0]);
            Assert.argNot((heartbeatInterval.toMillis() >= this.electionTimeout.toMillis() ? 1 : 0) != 0, (String)"heartbeatInterval must be less than electionTimeout", (Object[])new Object[0]);
            this.heartbeatInterval = (Duration)Assert.notNull((Object)heartbeatInterval, (String)"heartbeatInterval");
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            Assert.argNot((sessionTimeout.isNegative() || sessionTimeout.isZero() ? 1 : 0) != 0, (String)"sessionTimeout must be positive", (Object[])new Object[0]);
            Assert.argNot((sessionTimeout.toMillis() <= this.electionTimeout.toMillis() ? 1 : 0) != 0, (String)"sessionTimeout must be greater than electionTimeout", (Object[])new Object[0]);
            this.sessionTimeout = (Duration)Assert.notNull((Object)sessionTimeout, (String)"sessionTimeout");
            return this;
        }

        public RaftServer build() {
            if (this.stateMachine == null) {
                throw new ConfigurationException("state machine not configured", new Object[0]);
            }
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("net.kuujo.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            if (this.serializer == null) {
                this.serializer = new Serializer((BufferAllocator)new PooledDirectAllocator());
            }
            this.serializer.resolve(new SerializableTypeResolver[]{new ServiceLoaderTypeResolver()});
            if (this.storage == null) {
                this.storage = Storage.builder().withSerializer(this.serializer).build();
            }
            ServerContext context = new ServerContext(this.address, this.cluster, this.transport, this.storage, this.stateMachine, this.serializer).setHeartbeatInterval(this.heartbeatInterval).setElectionTimeout(this.electionTimeout).setSessionTimeout(this.sessionTimeout);
            return new RaftServer(context);
        }
    }

    public static enum State {
        INACTIVE,
        JOIN,
        LEAVE,
        PASSIVE,
        FOLLOWER,
        CANDIDATE,
        LEADER;

    }
}

