/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.concurrentunit.ConcurrentTestCase;
import net.kuujo.catalog.client.Command;
import net.kuujo.catalog.client.Query;
import net.kuujo.catalog.client.session.Session;
import net.kuujo.catalog.server.StateMachine;
import net.kuujo.catalog.server.state.ServerSession;
import net.kuujo.catalog.server.state.ServerStateMachine;
import net.kuujo.catalog.server.storage.CommandEntry;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.KeepAliveEntry;
import net.kuujo.catalog.server.storage.QueryEntry;
import net.kuujo.catalog.server.storage.RegisterEntry;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.SingleThreadContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class StateMachineTestCase
extends ConcurrentTestCase {
    private Context callerContext;
    private Context stateContext;
    private ServerStateMachine stateMachine;
    private Map<Long, Long> sequence;
    private Set<Long> cleaned;

    @BeforeMethod
    public void setupStateMachine() {
        this.sequence = new HashMap<Long, Long>();
        this.cleaned = new HashSet<Long>();
        this.callerContext = new SingleThreadContext("caller", new Serializer());
        this.stateContext = new SingleThreadContext("state", new Serializer());
        this.stateMachine = new ServerStateMachine(this.createStateMachine(), this.cleaned::add, this.stateContext);
    }

    protected abstract StateMachine createStateMachine();

    protected void assertCleaned(long index) {
        Assert.assertTrue((boolean)this.cleaned.contains(index));
    }

    protected void assertNotCleaned(long index) {
        Assert.assertFalse((boolean)this.cleaned.contains(index));
    }

    protected Session register(long index, long timestamp) throws Throwable {
        this.callerContext.execute(() -> {
            RegisterEntry entry = ((RegisterEntry)((RegisterEntry)((RegisterEntry)new RegisterEntry().setIndex(index)).setTerm(1L)).setTimestamp(timestamp)).setTimeout(500L).setConnection(UUID.randomUUID());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        ServerSession session = this.stateMachine.executor().context().sessions().getSession(index);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)session.id(), (long)index);
        Assert.assertEquals((long)session.getTimestamp(), (long)timestamp);
        return session;
    }

    protected Session keepAlive(long index, long timestamp, Session session) throws Throwable {
        this.callerContext.execute(() -> {
            KeepAliveEntry entry = ((KeepAliveEntry)((KeepAliveEntry)((KeepAliveEntry)((KeepAliveEntry)new KeepAliveEntry().setIndex(index)).setTerm(1L)).setSession(session.id())).setTimestamp(timestamp)).setCommandSequence(0L).setEventSequence(0L);
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        Assert.assertEquals((long)((ServerSession)session).getTimestamp(), (long)timestamp);
        return session;
    }

    protected <T> T apply(long index, long timestamp, Session session, Command<T> command) throws Throwable {
        Long sequence = this.sequence.get(session.id());
        sequence = sequence != null ? sequence + 1L : 1L;
        this.sequence.put(session.id(), sequence);
        CommandEntry entry = ((CommandEntry)((CommandEntry)((CommandEntry)((CommandEntry)new CommandEntry().setIndex(index)).setTerm(1L)).setSession(session.id())).setTimestamp(timestamp)).setSequence(sequence.longValue()).setCommand(command);
        return this.apply((Entry)entry);
    }

    protected <T> T apply(long timestamp, Session session, Query<T> query) throws Throwable {
        QueryEntry entry = ((QueryEntry)((QueryEntry)((QueryEntry)((QueryEntry)new QueryEntry().setIndex(this.stateMachine.getLastApplied())).setTerm(1L)).setSession(session.id())).setTimestamp(timestamp)).setVersion(0L).setQuery(query);
        return this.apply((Entry)entry);
    }

    private <T> T apply(Entry entry) throws Throwable {
        AtomicReference reference = new AtomicReference();
        this.callerContext.execute(() -> this.stateMachine.apply(entry).whenComplete((result, error) -> {
            if (error == null) {
                reference.set(result);
            } else {
                reference.set(error);
            }
            this.resume();
        }));
        this.await();
        Object result = reference.get();
        if (result instanceof Throwable) {
            throw (Throwable)result;
        }
        return (T)result;
    }

    @AfterMethod
    public void teardownStateMachine() {
        this.stateMachine.close();
        this.stateContext.close();
        this.callerContext.close();
    }
}

