/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalog.server.state;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.jodah.concurrentunit.ConcurrentTestCase;
import net.kuujo.catalog.client.Command;
import net.kuujo.catalog.client.Query;
import net.kuujo.catalog.server.Commit;
import net.kuujo.catalog.server.StateMachine;
import net.kuujo.catalog.server.StateMachineExecutor;
import net.kuujo.catalog.server.state.ServerSession;
import net.kuujo.catalog.server.state.ServerStateMachine;
import net.kuujo.catalog.server.storage.CommandEntry;
import net.kuujo.catalog.server.storage.Entry;
import net.kuujo.catalog.server.storage.KeepAliveEntry;
import net.kuujo.catalog.server.storage.NoOpEntry;
import net.kuujo.catalog.server.storage.QueryEntry;
import net.kuujo.catalog.server.storage.RegisterEntry;
import net.kuujo.catalyst.serializer.Serializer;
import net.kuujo.catalyst.util.concurrent.Context;
import net.kuujo.catalyst.util.concurrent.SingleThreadContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class ServerStateMachineTest
extends ConcurrentTestCase {
    private Context callerContext;
    private Context stateContext;
    private ServerStateMachine stateMachine;
    private long timestamp;
    private AtomicLong sequence;

    @BeforeMethod
    public void createStateMachine() {
        this.callerContext = new SingleThreadContext("caller", new Serializer());
        this.stateContext = new SingleThreadContext("state", new Serializer());
        this.stateMachine = new ServerStateMachine((StateMachine)new TestStateMachine(), i -> {}, this.stateContext);
        this.timestamp = System.currentTimeMillis();
        this.sequence = new AtomicLong();
    }

    public void testSessionRegisterKeepAlive() throws Throwable {
        this.callerContext.execute(() -> {
            RegisterEntry entry = ((RegisterEntry)((RegisterEntry)((RegisterEntry)new RegisterEntry().setIndex(1L)).setTerm(1L)).setTimestamp(this.timestamp)).setTimeout(500L).setConnection(UUID.randomUUID());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        ServerSession session = this.stateMachine.executor().context().sessions().getSession(1L);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)session.id(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)this.timestamp);
        this.callerContext.execute(() -> {
            KeepAliveEntry entry = ((KeepAliveEntry)((KeepAliveEntry)((KeepAliveEntry)((KeepAliveEntry)new KeepAliveEntry().setIndex(3L)).setTerm(1L)).setSession(1L)).setTimestamp(this.timestamp + 1000L)).setCommandSequence(0L).setEventSequence(0L);
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        Assert.assertEquals((long)session.getTimestamp(), (long)(this.timestamp + 1000L));
    }

    public void testSessionLeaderReset() throws Throwable {
        this.callerContext.execute(() -> {
            RegisterEntry entry = ((RegisterEntry)((RegisterEntry)((RegisterEntry)new RegisterEntry().setIndex(1L)).setTerm(1L)).setTimestamp(this.timestamp)).setTimeout(500L).setConnection(UUID.randomUUID());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        ServerSession session = this.stateMachine.executor().context().sessions().getSession(1L);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)session.id(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)this.timestamp);
        this.callerContext.execute(() -> {
            NoOpEntry entry = (NoOpEntry)((NoOpEntry)((NoOpEntry)new NoOpEntry().setIndex(2L)).setTerm(1L)).setTimestamp(this.timestamp + 100L);
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        Assert.assertEquals((long)session.getTimestamp(), (long)(this.timestamp + 100L));
    }

    public void testSessionExpire() throws Throwable {
        this.callerContext.execute(() -> {
            RegisterEntry entry = ((RegisterEntry)((RegisterEntry)((RegisterEntry)new RegisterEntry().setIndex(1L)).setTerm(1L)).setTimestamp(this.timestamp)).setTimeout(500L).setConnection(UUID.randomUUID());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        ServerSession session = this.stateMachine.executor().context().sessions().getSession(1L);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)session.id(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)this.timestamp);
        this.callerContext.execute(() -> {
            KeepAliveEntry entry = ((KeepAliveEntry)((KeepAliveEntry)((KeepAliveEntry)((KeepAliveEntry)new KeepAliveEntry().setIndex(3L)).setTerm(1L)).setSession(2L)).setTimestamp(this.timestamp + 1000L)).setCommandSequence(0L).setEventSequence(0L);
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNotNull(error);
                this.resume();
            });
        });
        this.await();
        Assert.assertTrue((boolean)session.isExpired());
    }

    public void testCommandSequence() throws Throwable {
        this.callerContext.execute(() -> {
            RegisterEntry entry = ((RegisterEntry)((RegisterEntry)((RegisterEntry)new RegisterEntry().setIndex(1L)).setTerm(1L)).setTimestamp(this.timestamp)).setTimeout(500L).setConnection(UUID.randomUUID());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
        });
        this.await();
        ServerSession session = this.stateMachine.executor().context().sessions().getSession(1L);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)session.id(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)this.timestamp);
        Assert.assertEquals((long)session.getVersion(), (long)1L);
        Assert.assertEquals((long)session.getSequence(), (long)0L);
        this.callerContext.execute(() -> {
            CommandEntry entry = ((CommandEntry)((CommandEntry)((CommandEntry)((CommandEntry)new CommandEntry().setIndex(2L)).setTerm(1L)).setSession(1L)).setTimestamp(this.timestamp + 100L)).setSequence(1L).setCommand((Command)new TestCommand());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertEquals(result, 1L);
                this.resume();
            });
        });
        this.await();
        Assert.assertEquals((long)session.getVersion(), (long)2L);
        Assert.assertEquals((long)session.getSequence(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)(this.timestamp + 100L));
        this.callerContext.execute(() -> {
            CommandEntry entry = ((CommandEntry)((CommandEntry)((CommandEntry)((CommandEntry)new CommandEntry().setIndex(3L)).setTerm(1L)).setSession(1L)).setTimestamp(this.timestamp + 200L)).setSequence(3L).setCommand((Command)new TestCommand());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertEquals(result, 3L);
                this.resume();
            });
        });
        this.callerContext.execute(() -> {
            CommandEntry entry = ((CommandEntry)((CommandEntry)((CommandEntry)((CommandEntry)new CommandEntry().setIndex(4L)).setTerm(1L)).setSession(1L)).setTimestamp(this.timestamp + 300L)).setSequence(2L).setCommand((Command)new TestCommand());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertEquals(result, 2L);
                this.resume();
            });
        });
        this.await(1000L, 2);
        Assert.assertEquals((long)session.getVersion(), (long)4L);
        Assert.assertEquals((long)session.getSequence(), (long)3L);
        Assert.assertEquals((long)session.getTimestamp(), (long)(this.timestamp + 300L));
    }

    public void testQuerySerialize() throws Throwable {
        this.callerContext.execute(() -> {
            RegisterEntry entry = ((RegisterEntry)((RegisterEntry)((RegisterEntry)new RegisterEntry().setIndex(1L)).setTerm(1L)).setTimestamp(this.timestamp)).setTimeout(500L).setConnection(UUID.randomUUID());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertNull(error);
                this.resume();
            });
            this.threadAssertEquals(this.stateMachine.getLastApplied(), 1L);
        });
        this.await();
        ServerSession session = this.stateMachine.executor().context().sessions().getSession(1L);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((long)session.id(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)this.timestamp);
        Assert.assertEquals((long)session.getVersion(), (long)1L);
        Assert.assertEquals((long)session.getSequence(), (long)0L);
        this.callerContext.execute(() -> {
            QueryEntry entry = ((QueryEntry)((QueryEntry)((QueryEntry)((QueryEntry)new QueryEntry().setIndex(this.stateMachine.getLastApplied())).setTerm(1L)).setSession(1L)).setTimestamp(this.timestamp + 200L)).setVersion(2L).setQuery((Query)new TestQuery());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertEquals(result, 2L);
                this.resume();
            });
        });
        this.callerContext.execute(() -> {
            CommandEntry entry = ((CommandEntry)((CommandEntry)((CommandEntry)((CommandEntry)new CommandEntry().setIndex(2L)).setTerm(1L)).setSession(1L)).setTimestamp(this.timestamp + 100L)).setSequence(1L).setCommand((Command)new TestCommand());
            this.stateMachine.apply((Entry)entry).whenComplete((result, error) -> {
                this.threadAssertEquals(result, 1L);
                this.resume();
            });
            this.threadAssertEquals(this.stateMachine.getLastApplied(), 2L);
        });
        this.await(1000L, 2);
        Assert.assertEquals((long)session.getVersion(), (long)2L);
        Assert.assertEquals((long)session.getSequence(), (long)1L);
        Assert.assertEquals((long)session.getTimestamp(), (long)(this.timestamp + 100L));
    }

    @AfterMethod
    public void closeStateMachine() {
        this.stateMachine.close();
        this.stateContext.close();
        this.callerContext.close();
    }

    private static class TestQuery
    implements Query<Long> {
        private TestQuery() {
        }
    }

    private static class TestCommand
    implements Command<Long> {
        private TestCommand() {
        }
    }

    private class TestStateMachine
    extends StateMachine {
        private TestStateMachine() {
        }

        public void configure(StateMachineExecutor executor) {
            executor.register(TestCommand.class, this::testCommand);
            executor.register(TestQuery.class, this::testQuery);
        }

        private long testCommand(Commit<TestCommand> commit) {
            return ServerStateMachineTest.this.sequence.incrementAndGet();
        }

        private long testQuery(Commit<TestQuery> commit) {
            return ServerStateMachineTest.this.sequence.incrementAndGet();
        }
    }
}

